package dressing.controller;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;

import dressing.model.Caisson;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Materiaux;
import dressing.model.Space3D;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.CaissonType;
import dressing.model.types.DosType;
import dressing.model.types.PieceType;
import dressing.model.types.PortType;
import dressing.model.types.PositionCalculationType;
import dressing.model.types.PositionReferenceType;
import dressing.model.types.SeprationAxe;

public class CaissonCreator implements Creator{
	String name;
	double longeur = 1000;
	double hauteur = 2050;
	double profondeur = 650;
	Materiaux basematerial=new Materiaux();
	Materiaux backmaterial=new Materiaux();
	DosType dostype = DosType.DOSINTERIEUR;
	boolean withseprator=false;
	PositionCalculationType positionCalculationtype = PositionCalculationType.PROPORTIONAL;
	double separationposition;
	SeprationAxe seprationaxe =SeprationAxe.XAXIS;
	boolean sepratortransversal=true;
	PortType porttype = PortType.FRANCAISE;
	Caisson caisson;
	DesignObject3D parent;
	CaissonType cuissontype = CaissonType.MILIEU;
	CaissonMontageType caissonMontageType=CaissonMontageType.CAISSON_MONTAGE_I;
	boolean withporte=false;	
	boolean separatorisometrique=false;
	PositionReferenceType sepPosRefType;
	double sepRetrait=0;
	double sepretraitderiere=0;

	public double getSepRetrait() {
		return sepRetrait;
	}
	public void setSepRetrait(double sepRetrait) {
		double oldValue = this.sepRetrait;
		this.sepRetrait = sepRetrait;
		firePropertyChange("sepRetrait", oldValue, sepRetrait);
	}
	public double getSepretraitderiere() {
		return sepretraitderiere;
	}
	public void setSepretraitderiere(double sepretraitderiere) {
		double oldValue = this.sepretraitderiere;
		this.sepretraitderiere = sepretraitderiere;
		firePropertyChange("sepretraitderiere", oldValue, sepretraitderiere);
	}
	public PositionReferenceType getSepPosRefType() {
		return sepPosRefType;
	}
	public void setSepPosRefType(PositionReferenceType sepPosRefType) {
		PositionReferenceType oldValue=this.sepPosRefType;
		this.sepPosRefType = sepPosRefType;
		firePropertyChange("sepPosRefType", oldValue,sepPosRefType);
	}

	public boolean isSeparatorisometrique() {
		return separatorisometrique;
	}

	public void setSeparatorisometrique(boolean separatorisometrique) {
		boolean oldValue = this.separatorisometrique;
		this.separatorisometrique = separatorisometrique;
		firePropertyChange("separatorisometrique", oldValue, separatorisometrique);
	}
	public CaissonMontageType getCaissonMontageType() {
		return caissonMontageType;
	}
	public void setCaissonMontageType(CaissonMontageType caissonMontageType) {
		CaissonMontageType oldValue = this.caissonMontageType;
		this.caissonMontageType = caissonMontageType;
		firePropertyChange("caissonMontageType", oldValue, caissonMontageType);
	}
	public void setCuissontype(CaissonType cuissontype) {
			CaissonType oldValue = this.cuissontype;
			this.cuissontype = cuissontype;
			firePropertyChange("cuissontype", oldValue, cuissontype);
	}
	public CaissonType getCuissontype() {
			return cuissontype;
	}
	public Materiaux getBasematerial() {
		return basematerial;
	}
	
	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(
			this);
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName,
			PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(propertyName,
				listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(String propertyName,
			PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(propertyName,
				listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue,
			Object newValue) {
			propertyChangeSupport.firePropertyChange(propertyName, oldValue,
					newValue);
	}

	public void setBasematerial(Materiaux basematerial) {
		Materiaux oldValue = this.basematerial;
		this.basematerial = basematerial;
		firePropertyChange("basematerial", oldValue, basematerial);
	}
	public Materiaux getBackmaterial() {
		return backmaterial;
	}
	public void setBackmaterial(Materiaux backmaterial) {
		Materiaux oldValue = this.backmaterial;
		this.backmaterial = backmaterial;
		firePropertyChange("backmaterial", oldValue, backmaterial);
	}
	public DosType getDostype() {
		return dostype;
	}
	public void setDostype(DosType dostype) {
		DosType oldValue = this.dostype;
		this.dostype = dostype;
		firePropertyChange("dostype", oldValue, dostype);
	}
	public boolean isWithseprator() {
		return withseprator;
	}
	public void setWithseprator(boolean withseprator) {
		boolean oldValue = this.withseprator;
		this.withseprator = withseprator;
		firePropertyChange("withseprator", oldValue, withseprator);
	}
	public PositionCalculationType getPositiontype() {
		return positionCalculationtype;
	}
	public void setPositiontype(PositionCalculationType positionCalculationtype) {
		PositionCalculationType oldValue = this.positionCalculationtype;
		this.positionCalculationtype = positionCalculationtype;
		firePropertyChange("positionCalculationtype", oldValue, positionCalculationtype);
	}
	public double getSeparationposition() {
		return separationposition;
	}
	public void setSeparationposition(double separationposition) {
		double oldValue = this.separationposition;
		this.separationposition = separationposition;
		firePropertyChange("separationposition", oldValue, separationposition);
	}
	public SeprationAxe getSeprationaxe() {
		return seprationaxe;
	}
	public void setSeprationaxe(SeprationAxe seprationaxe) {
		SeprationAxe oldValue = this.seprationaxe;
		this.seprationaxe = seprationaxe;
		firePropertyChange("seprationaxe", oldValue, seprationaxe);
	}
	public boolean isSepratortransversal() {
		return sepratortransversal;
	}
	public void setSepratortransversal(boolean sepratortransversal) {
		boolean oldValue = this.sepratortransversal;
		this.sepratortransversal = sepratortransversal;
		firePropertyChange("sepratortransversal", oldValue, sepratortransversal);
	}
	public PortType getPorttype() {
		return porttype;
	}
	public void setPorttype(PortType porttype) {
		PortType oldValue = this.porttype;
		this.porttype = porttype;
		firePropertyChange("porttype", oldValue, porttype);
	}
	public Caisson getCaisson() {
		return caisson;
	}
	public void setCaisson(Caisson caisson) {
		Caisson oldValue = this.caisson;
		this.caisson = caisson;
		firePropertyChange("caisson", oldValue, caisson);
	}
	public DesignObject3D getParent() {
		return parent;
	}
	public void setParent(DesignObject3D parent) {
		DesignObject3D oldValue = this.parent;
		this.parent = parent;
		firePropertyChange("parent", oldValue, parent);
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		String oldValue = this.name;
		this.name = name;
		firePropertyChange("name", oldValue, name);
	}
	public double getLongeur() {
		return longeur;
	}
	public void setLongeur(double longeur) {
		double oldValue = this.longeur;
		this.longeur = longeur;
		firePropertyChange("longeur", oldValue, longeur);
	}
	public double getHauteur() {
		return hauteur;
	}
	public void setHauteur(double hauteur) {
		double oldValue = this.hauteur;
		this.hauteur = hauteur;
		firePropertyChange("hauteur", oldValue, hauteur);
	}
	public double getProfondeur() {
		return profondeur;
	}
	public void setProfondeur(double profondeur) {
		double oldValue = this.profondeur;
		this.profondeur = profondeur;
		firePropertyChange("profondeur", oldValue, profondeur);
	}
	 
	public boolean isWithporte() {
		return withporte;
	}
	public void setWithporte(boolean withporte) {
		boolean oldValue = this.withporte;
		this.withporte = withporte;
		firePropertyChange("withporte", oldValue, withporte);
	}
	public void create() throws DesignException, GeometricEngineException{
		// TODO Auto-generated method stub
		createSubElements();
		//rectifier le xpos en fonctions des caissons qui existe deja
	    rectifyXpos();
	}
	
	public DesignObject3D getCaissonInstance() {
		// TODO Auto-generated method stub
		return caisson;
	}
	
	public void check() throws DesignException
	{
		
	}

	/**
	 * on doit appeler cette methode si on veuty faire la mise a jour de la position de xpos 
	 * lorsque on ajoute un caisson manuellment
	 */
	private void rectifyXpos() {

		double xpos = 0.0f;

		// calculer la somme des caissons existants

		List<DesignObject3D> childsList = this.getParent().getChilds();
		for (DesignObject3D a : childsList) {
			xpos += a.getLongeurext();
		}

		caisson.setXpos(xpos);
	}
	public void createSubElements() throws DesignException, GeometricEngineException
	{
		check();		//On met le controle dans une seule fonction
	    caisson = new Caisson();
	    caisson.setName(getName());
		caisson.setBackmaterial(getBackmaterial());
		caisson.setBasematerial(getBasematerial());
		caisson.setLongeurext(getLongeur());
		caisson.setHauteurext(getHauteur());
		caisson.setProfondeurext(getProfondeur());
		caisson.setParentdesign(parent);
		caisson.setCuissontype(getCuissontype());
		caisson.setPorttype(getPorttype());
		caisson.setDostype(((Space3D)parent).getDostype());
		caisson.setCaissonMontageType(getCaissonMontageType());
		caisson.constructDebitage();

		
		caisson.evaluate();		

		
		
		//creer les pieces necessaires
		Piece2DCreator piececreator = new Piece2DCreator();
		piececreator.setName("Bas");
		piececreator.setPiecetype(PieceType.BAS_CUISSON);
		piececreator.setBackmaterial(getBackmaterial());
		piececreator.setBasematerial(getBasematerial());
		piececreator.setMaterial(getBasematerial());
		piececreator.setParent(caisson);		
		piececreator.create();
		caisson.addElement(piececreator.getPiece2DInstance());
		

		
		
		piececreator.setName("Haut");
		piececreator.setPiecetype(PieceType.HAUT_CUISSON);
		piececreator.setMaterial(getBasematerial());
		piececreator.create();
		caisson.addElement(piececreator.getPiece2DInstance());

		
		piececreator.setName("Cote Droite");
		piececreator.setPiecetype(PieceType.DROITE_CUISSON);
		piececreator.setMaterial(getBasematerial());
		piececreator.create();
		caisson.addElement(piececreator.getPiece2DInstance());

		
		
		piececreator.setName("Cote Gauche");
		piececreator.setPiecetype(PieceType.GAUCHE_CUISSON);
		piececreator.setMaterial(getBasematerial());
		piececreator.create();
		caisson.addElement(piececreator.getPiece2DInstance());

//		if(!isWithseprator() || !isSepratortransversal())
//		{

				piececreator.setName("Dos");
				if(caisson.getDostype().equals(DosType.DOSEXTERIEUR))
				{
					piececreator.setPiecetype(PieceType.DOS_EXTERIRUR);
				}
				else if(caisson.getDostype().equals(DosType.DOSINTERIEUR))
				{
					piececreator.setPiecetype(PieceType.DOS_INTERIEUR);
				}

				piececreator.setMaterial(getBackmaterial());
				piececreator.create();
				caisson.addElement(piececreator.getPiece2DInstance());
//		}

		
		if(isWithseprator())
		{

			//Ajouter un seperateur
			if(isSepratortransversal())
			{
				//Creer le seprateur
				piececreator.setName("Seprateur Fixe");
				piececreator.setPiecetype(PieceType.SEPRATEUR_TRANSVERSANT);
				piececreator.setSeparationposition(getSeparationposition());
				piececreator.setSeprationaxe(getSeprationaxe());
				piececreator.setPositionCalculationType(getPositiontype());
				piececreator.setMaterial(getBasematerial());
				piececreator.setIsSepIsometrique(isSeparatorisometrique());
				piececreator.setSepPosRefType(getSepPosRefType());
				piececreator.setSepRetrait(getSepRetrait());
				piececreator.setSepretraitderiere(getSepretraitderiere());
				piececreator.create();
				caisson.addElement(piececreator.getPiece2DInstance());
							
				//creer les dos ici
			}
			else
			{
				//Creer le seprateur
				piececreator.setName("Seprateur Fixe");
				piececreator.setPiecetype(PieceType.SEPRATEUR_NORMAL);
				piececreator.setSeparationposition(getSeparationposition());
				piececreator.setSeprationaxe(getSeprationaxe());
				piececreator.setPositionCalculationType(getPositiontype());
				piececreator.setMaterial(getBasematerial());
				piececreator.setIsSepIsometrique(isSeparatorisometrique());
				piececreator.setSepPosRefType(getSepPosRefType());
				piececreator.setSepRetrait(getSepRetrait());
				piececreator.setSepretraitderiere(getSepretraitderiere());
				piececreator.create();
				caisson.addElement(piececreator.getPiece2DInstance());
			}

			
		}
		
		if(isWithporte())
		{
			if(getPorttype().equals(PortType.FRANCAISE))
			{
				//Creer le seprateur
				piececreator.setName("Porte");
				piececreator.setPiecetype(PieceType.PORTE);
				piececreator.setMaterial(getBasematerial());
				piececreator.create();
				caisson.addElement(piececreator.getPiece2DInstance());
			}
			else if(getPorttype().equals(PortType.FRANCAISE2V))
			{
				//Creer le seprateur
				piececreator.setName("Porte Gauche");
				piececreator.setPiecetype(PieceType.PORTE_GAUCHE);
				piececreator.setMaterial(getBasematerial());
				piececreator.create();
				caisson.addElement(piececreator.getPiece2DInstance());
				
				//Creer le seprateur
				piececreator.setName("Porte Droite");
				piececreator.setPiecetype(PieceType.PORTE_DROITE);
				piececreator.setMaterial(getBasematerial());
				piececreator.create();
				caisson.addElement(piececreator.getPiece2DInstance());
			}
		}
	}
}
