package dressing.model.usinage;

import java.util.ArrayList;
import java.util.List;

import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Intervale;
import dressing.model.Plan3D;
import dressing.model.Vertice3D;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.DesignType;

public class TriCavity extends Usinage{

	boolean exist=true;
	private List<Vertice3D> vertices=new ArrayList<Vertice3D>();
	@Override
	public void updateproperties() throws GeometricEngineException {
		if(getDesignType() !=null && getDesignType().equals(DesignType.GENERIC)) {
			super.updateproperties();
			return;
		}
		DesignObject3D parent=getParentdesign();
		if(parent==null ) {
			throw new GeometricEngineException("le Piece parent de cette rainure "+getName()+" est inexistent il faut l'insérer");
		}
		
		if(getMother()==null) {
			throw new GeometricEngineException("le dos de cette rainure "+getName()+" est inexistent il faut l'insérer");
		}
		double xpos=getXpos();
		double ypos=getYpos();
		double zpos=getZpos();
		
		double longeur=getLongeurext();
		double hauteur=getHauteurext();
		double profondeur=getProfondeurext();
		Plan3D inter = parent.getIntersect(getMother());
		
		Intervale xinter=inter.getXinter();
		Intervale yinter=inter.getYinter();
		Intervale zinter=inter.getZinter();
		
		if(xinter==null||yinter==null||zinter==null) {
			this.exist=false;
		}else {
			this.exist=true;
			try {
				xpos=xinter.getMininter();
				ypos=yinter.getMininter();
				zpos=zinter.getMininter();
				
				longeur=xinter.getlong();
				hauteur=yinter.getlong();
				profondeur=zinter.getlong();

			} catch (NullPointerException e) {
				e.printStackTrace();
			}
			setXpos(xpos-parent.getXPosABS());
			setYpos(ypos-parent.getYPosABS());
			setZpos(zpos-parent.getZPosABS());
			
			setLongeurext(longeur);
			setLongeurint(longeur);
			
			setHauteurext(hauteur);
			setHauteurint(hauteur);

			setProfondeurext(profondeur);
			setProfondeurint(profondeur);
		}

		

	}
	
	
	@Override
	public DesignObject3D clone() {
		TriCavity space=new TriCavity();
		try {
			space=(TriCavity) this.copy(space);
		} catch (DesignException | GeometricEngineException | CloneNotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return space;
	}
	@Override
	public DesignObject3D copy(DesignObject3D object) throws DesignException, GeometricEngineException, CloneNotSupportedException {
		TriCavity rainure=(TriCavity) object;
		rainure=(TriCavity) super.copy(rainure);
		return rainure;
	}


	public boolean isExist() {
		return exist;
	}


	public void setExist(boolean exist) {
		this.exist = exist;
	}


	public List<Vertice3D> getVertices() {
		return vertices;
	}


	public void setVertices(List<Vertice3D> vertices) {
		this.vertices = vertices;
	}
	
}
