package dressing.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import param.Material;

public class Materiaux {
	private String name;
	private double epaisseur;
	private String motif;
	private String couleur;

	public Materiaux() {
		// TODO Auto-generated constructor stub
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		String oldValue = this.name;
		this.name = name;
		firePropertyChange("name", oldValue, name);
	}

	public double getEpaisseur() {
		return epaisseur;
	}

	public void setEpaisseur(double epaisseur) {

		double oldValue = this.epaisseur;
		this.epaisseur = epaisseur;
		firePropertyChange("epaisseur", oldValue, epaisseur);
	}

	public String getMotif() {
		return motif;
	}

	public void setMotif(String motif) {

		String oldValue = this.motif;
		this.motif = motif;
		firePropertyChange("motif", oldValue, motif);
	}

	public String getCouleur() {
		return couleur;
	}

	public void setCouleur(String couleur) {

		String oldValue = this.couleur;
		this.couleur = couleur;
		firePropertyChange("couleur", oldValue, couleur);
	}

	@Override
	public String toString() {
		return "Materiaux [name=" + name + ", epaisseur=" + epaisseur + ", motif=" + motif + ", couleur=" + couleur
				+ "]";
	}

	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
		propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
	}

	@Override
	public boolean equals(Object obj) {
		// TODO Auto-generated method stub
		if (obj instanceof Materiaux) {
			if (obj != null && ((Materiaux) obj).name != null && ((Materiaux) obj).epaisseur == this.epaisseur
					&& ((Materiaux) obj).name.equals(this.name)) {
				return true;
			}
		}
		return super.equals(obj);
	}

	@Override
	public int hashCode() {
		// TODO Auto-generated method stub
		return (int) getEpaisseur();
	}

	public void initafterread() {
		propertyChangeSupport = new PropertyChangeSupport(this);
//		this.addPropertyChangeListener(new PropertyChangeListener() {
//			
//			@Override
//			public void propertyChange(PropertyChangeEvent evt) {
//				// TODO Auto-generated method stub
//				firePropertyChange("project.modify", null, evt.getNewValue());
//			}
//		});
		firePropertyChange("project.modify", null, this);

	}

	public static Materiaux getFromMaterial(Material m) {
		Materiaux material = new Materiaux();
		material.setName(m.getName());
		material.setEpaisseur(m.getEpaisseur());
		material.setMotif(m.getImage());
		return material;
	}
}
