package dressing.model;

import java.awt.image.BufferedImage;
import java.util.List;

import dressing.model.debitage.Debitage;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.PortType;

public class Cuisine extends Dressing {
	 PortType porttype;
	

	public Cuisine() {
		super();
		// TODO Auto-generated constructor stub
	}

	@Override
	public void update() throws Exception {
		// TODO Auto-generated method stub
		 for (DesignObject3D obj : getChilds()) {
			 	if (obj instanceof Caisson) {
					Caisson cuis = (Caisson) obj;
			 		cuis.updateMaterialFromParent(this);
					try {
						cuis.propagateUpdateToChildrens(this);
						cuis.setErrorexist(false);
						cuis.setErrormsg("");
					} catch (Exception e) {
						// TODO: handle exception
						cuis.setErrorexist(true);
						cuis.setErrormsg(e.getMessage());
						this.setErrorexist(true);
						this.setErrormsg(e.getMessage());
						firePropertyChange("project.error", null, true);
						throw e;
					} finally {

					}

				}
			}
			setUpdatechildsPositions();
			this.setErrorexist(false);
			this.setErrormsg("");
//			firePropertyChange("project.modify", null, this);
			firePropertyChange("project.recalculate", null, this);
		
	}

	@Override
	public boolean canHold(DesignObject3D child) {
		// TODO Auto-generated method stub
		if(child instanceof CaissonCuisine||child instanceof Space3DFree) {
			return true;
		}
		return false;
	}

	@Override
	public boolean isdrawable() {
		// TODO Auto-generated method stub
		return false;
	}
	public PortType getPorttype() {
		return porttype;
	}



	public void setPorttype(PortType porttype) {
		PortType oldValue = this.porttype;
		this.porttype = porttype;
		firePropertyChange("porttype", oldValue, porttype);
	}
	public String printDescription()
	{		
		String s="";
		s+=" Cuisine "  + getName() +"\n";
		s+=" Longeur externe "  + getLongeurext() +" mm \n";
		s+=" Hauteur externe "  + getHauteurext() +" mm \n";
		s+=" Profondeur externe "  + getProfondeurext() +" mm \n";		
		s+=" Longeur interne "  + getLongeurint() +" mm \n";
		s+=" Hauteur interne "  + getHauteurint() +" mm \n";
		s+=" Profondeur interne "  + getProfondeurint() +" mm \n";
		
		s+="#################### Les sous elements ########## \n";
		System.out.println(s);
		for(DesignObject3D child : getChilds())
		{
			s+=child.printDescription();
		}
		
		return s;
	}
	@Override
	public double getXSize() {
		// TODO Auto-generated method stub
		return getLongeurext();
	}
	@Override
	public double getYSize() {
		// TODO Auto-generated method stub
		return getHauteurext();
	}
	@Override
	public double getZSize() {
		// TODO Auto-generated method stub
		return getProfondeurext();
	}
	@Override
	public double getXPosition() {
		// TODO Auto-generated method stub
		return 0;
	}
	@Override
	public double getYPosition() {
		// TODO Auto-generated method stub
		return 0;
	}
	@Override
	public double getZPosition() {
		// TODO Auto-generated method stub
		return 0;
	}
	@Override
	public List getChildren() {
		// TODO Auto-generated method stub
		return getChilds();
	}
	@Override
	public BufferedImage getImage() {
		// TODO Auto-generated method stub
		return null;
	}
	

	@Override
	public DesignObject3D clone() {
		Cuisine space=new Cuisine();
		try {
			space=(Cuisine) this.copy((DesignObject3D)space);
		} catch (DesignException | GeometricEngineException | CloneNotSupportedException e) {
			e.printStackTrace();
		}
		return space;
	}
	@Override
	public DesignObject3D copy(DesignObject3D object) throws DesignException, GeometricEngineException, CloneNotSupportedException {
		Cuisine cuisine=(Cuisine) object;
		cuisine=(Cuisine) super.copy(cuisine);
		cuisine.setPorttype(getPorttype());
		return cuisine;
	}
}
