package dressing.handlers;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

import dressing.model.ModelPackageProject3D;
import dressing.model.Project3D;
import dressing.ui.cuisine.CuisineWizard;
import dressing.ui.dressing.DressingWizard;
import dressing.ui.parts.ModelPackageTreePart;
import dressing.ui.parts.ProjectTreePart;

public class AddCuisineHandler {
@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute(EPartService partService,Shell shell){
		Object o = null;		
		MPart part=partService.getActivePart();
		Object activePart = part.getObject();
		 if(activePart instanceof ModelPackageTreePart) {
			 o = selectionService.getSelection("dressing.part.bibliothque");
		 }else {
			o= selectionService.getSelection("dressing.part.tree"); 
		 }
		if(activePart instanceof ProjectTreePart) {

			//Voire l element de l arbre selectionne		
			if(o!=null && o instanceof Project3D)
			{
				Project3D project =(Project3D)o;
				CuisineWizard cuisinewizrad = ContextInjectionFactory.make(CuisineWizard.class,eclipsecontext);
				cuisinewizrad.setProject3d(project);
				WizardDialog dialog = new WizardDialog(shell, cuisinewizrad);
				dialog.open();		
	
			}	
		
		}else if(activePart instanceof ModelPackageTreePart) {
			
			if(o!=null && o instanceof ModelPackageProject3D)
			{		
				ModelPackageProject3D project =(ModelPackageProject3D)o;
				CuisineWizard cuisinewizrad = ContextInjectionFactory.make(CuisineWizard.class,eclipsecontext);
				cuisinewizrad.setProject3d(project);
				WizardDialog dialog = new WizardDialog(shell, cuisinewizrad);
				dialog.open();		
				
			}
		}
	}
	@CanExecute
	public boolean check(EPartService partService)
	{
		Object o = null;
		
		MPart part=partService.getActivePart();
		Object activePart = part.getObject();
		 if(activePart instanceof ModelPackageTreePart) {
			 o = selectionService.getSelection("dressing.part.bibliothque");
		 }else {
			o= selectionService.getSelection("dressing.part.tree"); 
		 }	
		//Voire l element de l arbre selectionne
		if(o!=null && o instanceof Project3D)
		{
			return true;
		}	
		return false;
	}

}
