package dressing.cam.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.CoordinateSystem;
import dressing.model.ModelProvider;
import dressing.model.Piece2D;
import dressing.model.Point3D;
import dressing.model.types.Orientation;
import dressing.model.types.PieceType;
import dressing.model.usinage.Direction;
import dressing.model.usinage.Rainure;
import dressing.model.usinage.Trou;
import dressing.model.usinage.Usinage;

public class HoleMasterGcodeGenerator implements GcodeGenerator {

	public final String N = System.getProperty("line.separator");
    public static HoleMasterGcodeGenerator instance;
	public static HoleMasterGcodeGenerator getInstance() {
 		synchronized(HoleMasterGcodeGenerator.class) {
 			if (instance == null) {
 				instance = new HoleMasterGcodeGenerator();
 			}
 			return instance;
 		}
	}
	@Override
	public String generateHoleBlock(String tool, int face, Vector3 start, Vector3 end, int depth) {
		String operatioLine = "O" + face + " T" + tool + N;
        String block = "";
        block += operatioLine;
        block += "F0" + N;
        String startLine = "G0 X" + (int)start.x+ " Y" + (int)start.y+ " Z" + (int)start.z + N;
        block += startLine;
        String endLine = "";
        endLine = "G1 X" + (int)end.x+ " Y" + (int)end.y + " Z" +(int)end.z + N;
        block += endLine;
        return  block;
	}
	@Override
	public String generateHeader(Vector3 point) {
		String header = "L" +((int) point.x) + " W"+ ((int)point.y)+ " D" + ((int)point.z) + N;
		return header;
	}
	@Override
	public String generaterRainureBlock(String tool, int face, Vector3 start, Vector3 end, int depth) {
		String operatioLine = "O" + face + " T" + tool + N;
        String block = "";
        block += operatioLine;
        block += "F0" + N;
        String startLine = "G0 X" + (int)start.x+ " Y" + (int)start.y + " Z" + (int)start.z + N;
        block += startLine;
        String endLine = "";
        endLine = "G1 X" + (int)end.x+ " Y" + (int)end.y + " Z" +(int)end.z + N;
        block += endLine;
       //System.err.println(block);
        return  block;
	}
	
	//face 100
	@Override
	public String generaterRectangulaireFreizeBlock(String tool,int face,  Vector3 point1, Vector3 point2, Vector3 point3, Vector3 point4,
			Vector3 piece, int depth, float cutterRadius) {
		String operatioLine ="O" + face + " T" + tool + N;
		String f= "F0" + N;
        String block = "";
        String block_1, block_2, block_3, block_4;
        //block-1
         if(point1.y > 0) {
			//
			float x1 = point1.x;
			float x2 = point2.x;
			float y = point1.y;
			if (x1 != 0) {
				x1 += cutterRadius;
			}
			if (x2 != piece.x) {
				x2 -= cutterRadius;
			}
			y += cutterRadius;
			//
        	  block_1 = "G0 X" + x1+ " Y" + y + " Z" + (int)piece.z + N;
              String endblock_1 = "G1 X" + x2+ " Y" + y + " Z" + ((int)piece.z-depth) + N;
              block+=operatioLine+f+block_1+endblock_1;
         }
       
         //block-2
         if(point2.x < piece.x ){
			//
			float y1 = point2.y;
			float y2 = point3.y;
			float x = point2.x;
			if (y1 != 0) {
				y1 += cutterRadius;
			}
			if (y2 != piece.y) {
				y2 -= cutterRadius;
			}
			x -= cutterRadius;
			//
        	 block_2 = "G0 X" + x+ " Y" + y1 + " Z" + (int)piece.z + N;
             String endblock_2 = "G1 X" + x+ " Y" + y2 + " Z" + ((int)piece.z-depth) + N;
             block+=operatioLine+f+block_2+endblock_2;
         }
         
         //block-3
         if(point3.y < piece.y) {
        	 //
 			float x1 = point3.x;
 			float x2 = point4.x;
 			float y = point3.y;
 			if (x1 != piece.x) {
 				x1 -= cutterRadius;
 			}
 			if (x2 != 0) {
 				x2 += cutterRadius;
 			}
 			y -= cutterRadius;
 			//
        	  block_3 = "G0 X" + x1+ " Y" + y + " Z" + (int)piece.z + N;
              String endblock_3 = "G1 X" + x2+ " Y" + y + " Z" + ((int)piece.z-depth) + N;
              block+=operatioLine+f+block_3+endblock_3;
         }
       
         //block-4
         if(point4.x > 0) {
     		//
 			float y1 = point4.y;
 			float y2 = point1.y;
 			float x = point4.x;
 			if (y1 != piece.y) {
 				y1 -= cutterRadius;
 			}
 			if (y2 != 0) {
 				y2 += cutterRadius;
 			}
 			x += cutterRadius;
 			//
        	 block_4 = "G0 X" + x + " Y" + y1 + " Z" + (int)piece.z + N;
             String endblock_4 = "G1 X" + x + " Y" + y2 + " Z" + ((int)piece.z -depth) + N;
             block+=operatioLine+f+block_4+endblock_4; 
         }
       // System.err.println(block);
        return  block;
	}

	
	public void generateCode(Piece2D piece) {

		SystemCoordinateSwitcher scs = new SystemCoordinateSwitcher();
		scs.init(piece);
		List<Trou> trouList = piece.getTrous();
		List<Usinage> cavities = piece.getCavities();
		
		ArrayList<Operation> trouOperations = new ArrayList<Operation>();
		for(Trou trou: trouList) {
			trouOperations.addAll(trou.getOperations());
		}
		Map<Tool,List<Operation>> layers = new HashMap<Tool, List<Operation>>();
		
		for(Operation operation: trouOperations) {
			Tool tool = operation.getTool();
			List<Operation> toolsOperations;
			if(layers.containsKey(tool)) {
				 toolsOperations = layers.get(tool);
			}else {
				toolsOperations = new ArrayList<Operation>();
				layers.put(tool, toolsOperations);
			}
			toolsOperations.add(operation);
		}
		ArrayList<Operation> sortedOperations = new ArrayList<Operation>();
 		for(Usinage cavity: cavities) {
 			sortedOperations.addAll(cavity.getOperations());
 		}
		
		for(Tool tool: layers.keySet()) {
			Util.sortOps(layers.get(tool));
			sortedOperations.addAll(layers.get(tool));
		}
				
		Vector3 dimension = CoordinateSystem.getPieceDimension(piece);
		
		float length = dimension.x;
		float depth = dimension.z;
		float width = dimension.y;
		Vector3 vector;
		switch (piece.getPieceOrientation()) {
		case VERTICAL:
			vector = Vector3.X;
			break;
		case HORIZONTAL:
			vector = Vector3.Y;
		break;
		case PROUFOUND:
			vector = Vector3.Z;
			break;
		default:
			vector = Vector3.Z;
			break;
		}
		
		String header = generateHeader(new Vector3((float)length,(float) width,(float) depth));
		String gcode = "";
		String gcodeBack = "";
		String lateralTrou = "";
		String lateralTrouBack = "";
		String extrusion = "";
		String extrusionback = "";
		String gcodeRainure = "";
		String gcodeBackRainure = "";
		for (Operation op : sortedOperations) {
				Tool tool = op.getTool();
					Usinage usin = op.getUsin();
					if (usin instanceof Trou) {
						Trou cercle = (Trou) usin;
						Vector3 start = scs.toMachineCoordinate(cercle.getStart());
						Vector3 end = scs.toMachineCoordinate(cercle.getEnd());
						
						double sense = start.z;
						start.z = (float) depth;
						if (sense == 0) {
							end.z *= -1;
							end.z += depth;
							start.x = (float) (length - start.x);
							end.x = (float) (length - end.x);
						}
						int face =getTrouface(start, end);
						Tool opTool=getTool((Trou) usin, op, face);
						if(opTool!=null) {
							double cheek = getCheek(cercle,piece.getPieceOrientation(),piece);
							if (cheek == 0) {
								gcode += generateHoleBlock(opTool.getCode(), face, start, end,
										(int) cercle.getDepth());
							}
							if(cheek == 1) {
								gcodeBack += generateHoleBlock(opTool.getCode(), face, start, end,
										(int) cercle.getDepth());
							}
							if(cheek == 100) {
								lateralTrou += generateHoleBlock(opTool.getCode(), face, start, end,
										(int) cercle.getDepth());
								start.x=length-start.x;
								end.x=length-end.x;
								face=getTrouface(start, end);
								opTool=getTool((Trou) usin, op, face);
								lateralTrouBack += generateHoleBlock(opTool.getCode(), face, start, end,
										(int) cercle.getDepth());
							}
						}
						
					} else {

						if (op.getUsin() instanceof Rainure) {
 
							Rainure rainure = (Rainure) op.getUsin();

							float depthR = vector.dot(new Vector3((float)rainure.getLongeurext(), (float)rainure.getHauteurext(), (float) rainure.getProfondeurext())); 
							double distance = Math.max(Math.max(rainure.getLongeurext(), rainure.getHauteurext()),
									rainure.getProfondeurext());
							Vector3 start = new Vector3((float)rainure.getXpos(),(float) rainure.getYpos(),(float) rainure.getZpos());
							Vector3 end = new Vector3((float)rainure.getXpos(), (float)rainure.getYpos() ,(float)rainure.getZpos());
							if (distance == rainure.getLongeurext()) {
								start.z += rainure.getProfondeurext()/2;
								end.x += distance;
								end.y = start.y;
								end.z = start.z;
							} else if (distance == rainure.getHauteurext()) {
								if(start.x == 0) {
									start.x += rainure.getLongeurext();
								}
								//test if the piece is profondeur and rainure move on the axe Y 
								//we move the axe X to be in the middle of the width of the rainure
								//and otherwise meaning the piece is vertical we move the axe X to be in the middle of the width of the rainure
								if(vector==Vector3.Z) {
									start.x += rainure.getLongeurext() / 2;
									end.y += distance;
									end.x = start.x;
									end.z = start.z;
								}else {
									start.z += rainure.getProfondeurext() / 2;
									end.y += distance;
									end.x = start.x;
									end.z = start.z;
								}
								
							} else {
								start.x += rainure.getLongeurext() / 2;
								end.z += distance;
								end.x = start.x;
								end.y = start.y;
							}
							Vector3 startX = scs.toMachineCoordinate(start);
							Vector3 endX = scs.toMachineCoordinate(end);
							if(startX.x > endX.x) {
								Vector3 bucket = startX;
								startX = endX;
								endX = bucket;
							}
							startX.z = (float) depth;
//							if(flip) {
//								endX.z *= -1;
//								endX.z += depth;
//							}
							int face=6;
							if(startX.x==endX.x) {
								face=1;
							}
							endX.z=(float) (depth-depthR);
							int cheek = getCheek(rainure, piece.getPieceOrientation(), piece);
							if(face==6)//ne pas passer le rainure si son axe est diffirent du X
							{
								if(cheek == 0) 
								{	
									if(vector==Vector3.Z||vector==Vector3.X) {
										startX.x=length-startX.x;
										endX.x=length-endX.x;
										if(startX.x > endX.x) {
											Vector3 bucket = startX;
											startX = endX;
											endX = bucket;
										}
										startX.z = (float) depth;
										endX.z=(float) (depth-depthR);
									}									
									gcodeRainure += generaterRainureBlock(tool.getCode(), face, startX, endX, -1);
								}
								if (cheek == 1)
								{
									if(vector==Vector3.Y) {
										startX.x=length-startX.x;
										endX.x=length-endX.x;
										if(startX.x > endX.x) {
											Vector3 bucket = startX;
											startX = endX;
											endX = bucket;
										}
										startX.z = (float) depth;
										endX.z=(float) (depth-depthR);
									}	
									gcodeBackRainure += generaterRainureBlock(tool.getCode(), face, startX, endX, -1);	
								}
							}
							
							
						} else {

							Cuboid cubeD = (Cuboid) op.getShape();
							Usinage cube = cubeD.getCube();
							int cavityDepth = (int) vector.dot(new Vector3((float)cube.getLongeurext(), (float)cube.getHauteurext(), (float) cube.getProfondeurext())); 

							Vector3 vertice000 = new Vector3((float)cube.getXpos(), (float)cube.getYpos(),(float) cube.getZpos());
							Vector3 vertice001 = new Vector3((float)cube.getXpos(),(float) cube.getYpos(),(float)
									cube.getZpos() + (float)cube.getProfondeurext());
							Vector3 vertice010 = new Vector3((float)cube.getXpos(),(float) cube.getYpos() + (float)cube.getHauteurext(),
									(float)cube.getZpos());
							Vector3 vertice011 = new Vector3((float)cube.getXpos(), (float)cube.getYpos() +(float) cube.getHauteurext(),
									(float)cube.getZpos() + (float)cube.getProfondeurext());
							Vector3 vertice100 = new Vector3((float)cube.getXpos() + (float)cube.getLongeurext(), (float)cube.getYpos(),
									(float)cube.getZpos());
							Vector3 vertice101 = new Vector3((float)cube.getXpos() + (float)cube.getLongeurext(), (float)cube.getYpos(),
									(float)cube.getZpos() + (float)cube.getProfondeurext());
							Vector3 vertice110 = new Vector3((float)cube.getXpos() +(float) cube.getLongeurext(),
									(float)cube.getYpos() +(float) cube.getHauteurext(),(float) cube.getZpos());
							Vector3 vertice111 = new Vector3((float)cube.getXpos() + (float)cube.getLongeurext(),
									(float)cube.getYpos() +(float) cube.getHauteurext(),(float) cube.getZpos() + (float)cube.getProfondeurext());
							vertice000 = scs.toMachineCoordinate(vertice000);
							vertice001 = scs.toMachineCoordinate(vertice001);
							vertice010 = scs.toMachineCoordinate(vertice010);
							vertice011 = scs.toMachineCoordinate(vertice011);
							vertice100 = scs.toMachineCoordinate(vertice100);
							vertice101 = scs.toMachineCoordinate(vertice101);
							vertice110 = scs.toMachineCoordinate(vertice110);
							vertice111 = scs.toMachineCoordinate(vertice111);
							ArrayList<Vector3> vertices = new ArrayList<Vector3>();
							vertices.add(vertice111);
							vertices.add(vertice110);
							vertices.add(vertice101);
							vertices.add(vertice100);
							vertices.add(vertice011);
							vertices.add(vertice010);
							vertices.add(vertice001);
							vertices.add(vertice000);
							int j = 0;
							ArrayList<Vector3> verticesToConsider = new ArrayList<Vector3>();
							while (verticesToConsider.size() < 4) {
								for (int i = j; i < vertices.size(); i++) {
									if (vertices.get(i) == vertices.get(j)
											|| verticesToConsider.contains(vertices.get(i)))
										continue;
									if (vertices.get(i).x == vertices.get(j).x && vertices.get(i).y == vertices.get(j).y)
										verticesToConsider.add(vertices.get(i));
								}
								j++;
							}
							String gcodeExtrusion1="";
							String gcodeExtrusion2="";
							Vector3[] points = sortVertices(verticesToConsider, dimension,tool);
							int face =100;
							gcodeExtrusion1 += generaterRectangulaireFreizeBlock(tool.getCode(),face, points[0], points[1],
									points[2], points[3], dimension, cavityDepth, (float)tool.getCutter_diameter() / 2f);
							for(Vector3 v:verticesToConsider) {
								v.x=length-v.x;
								
							}
							points = sortVertices(verticesToConsider, dimension,tool);

							gcodeExtrusion2 += generaterRectangulaireFreizeBlock(tool.getCode(),face, points[0], points[1],
									points[2], points[3], dimension, cavityDepth, (float)tool.getCutter_diameter() / 2f);
							if(vector==Vector3.Z||vector==Vector3.X) {
								extrusionback+=gcodeExtrusion1;
								extrusion+=gcodeExtrusion2;
							}else {
								extrusionback+=gcodeExtrusion2;
								extrusion+=gcodeExtrusion1;
							}
						}
					}
					
		}
		boolean lateralAdded = false;
		if (!gcode.isEmpty()||!gcodeRainure.isEmpty()) {
			String code=header;
			code+=gcodeRainure;
			if(!piece.getPiecetype().equals(PieceType.BAS_CUISSON)&&!gcode.isEmpty()&& gcodeBack.isEmpty()) {
				code+=extrusion;		
				code+=lateralTrou;
				lateralAdded = true;
			}
			
			code+=gcode;
			piece.put("gcode_face", code);	
		}
		if (!gcodeBack.isEmpty()|| !gcodeBackRainure.isEmpty()) {
			String code=header;
			code+=gcodeBackRainure;
			
			if(!lateralAdded) {
				
				code += extrusionback;
				code += lateralTrouBack;
				lateralAdded = true;
			}
			code+=gcodeBack;
			piece.put("gcode_back", code);
		}
		if(!lateralAdded && (!extrusion.isEmpty()|| !lateralTrou.isEmpty())){
			gcode=header;
			gcode+=gcodeRainure;
			gcode += extrusion;
			gcode += lateralTrou;
			piece.put("gcode_face", gcode);	
			lateralAdded = true;

		}
	}
	public int getTrouface(Vector3 start,Vector3 end) {
		int face = 1;
		if (start.x < end.x)
			face = 2;
		if (start.x > end.x)
			face = 3;
		if (start.y < end.y)
			face = 4;
		if (start.y >end.y)
			face = 5;
		
		return face;
	}
	public Tool getTool(Trou usin, Operation op,int face) {
		List<Tool> tools=ModelProvider.getTools();
		Tool opTool=null;
		Tool tool=op.getTool();
		if(tool!=null) {
			String faceProp=tool.getProperty("face");
			if(faceProp!=null&& !faceProp.isEmpty()) {
				String[] faces=faceProp.split(",");
				for(String f:faces) {
					int fa=Integer.valueOf(f);
					if(fa==face) {
						opTool= tool;
					}
				}
			}
		}
		
		for(Tool tt:tools) {
			if(tt!=null) {
				String faceProp=tt.getProperty("face");
				if(faceProp!=null&& !faceProp.isEmpty()) {
					String[] faces=faceProp.split(",");
					for(String f:faces) {
						int fa=Integer.valueOf(f);
						if(fa==face) {
							if(opTool==null) {
								opTool=tt;
							}
							if(Math.abs(tt.getCutter_diameter()-usin.getDiameter())<Math.abs(opTool.getCutter_diameter()-usin.getDiameter())) {
								opTool=tt;
							}
						}
					}
				}
			}
		}
		
		return opTool;
		
	}
	private Vector3[] sortVertices(ArrayList<Vector3> vertices, Vector3 piece, Tool tool) {
		Vector3 p1, p2, p3, p4;
		float minX = 10000, maxX = 0, minY = 10000, maxY = 0;
		for (Vector3 point : vertices) {
			if (point.x < minX)
				minX = point.x;
			if (point.x > maxX)
				maxX = point.x;
			if (point.y < minY)
				minY = point.y;
			if (point.y > maxY)
				maxY = point.y;
		}
//		minX += tool.getCutter_diameter() / 2;
//		maxX -= tool.getCutter_diameter() / 2;
//		minY += tool.getCutter_diameter() / 2;
//		maxY -= tool.getCutter_diameter() / 2;

		p1 = new Vector3(minX, minY, piece.z);
		p2 = new Vector3(maxX, minY, piece.z);
		p3 = new Vector3(maxX, maxY, piece.z);
		p4 = new Vector3(minX, maxY, piece.z);

		return new Vector3[] { p1, p2, p3, p4 };
	}
	public int getCheek(Usinage usin, Orientation orientation, Piece2D piece) {
		int cheek = -1;
		if(usin instanceof Trou) {
			Trou trou = (Trou) usin;
			Direction direction = trou.getDirection();
			if(orientation == Orientation.HORIZONTAL){
				switch(direction){
				case YMINUS:
					cheek  = 0;
					break;
				case YPLUS:
					cheek = 1;
					break;
				default:
					cheek = 100;
				}
			}else if(orientation == Orientation.VERTICAL) {
				switch(direction){
				case XMINUS:
					cheek = 0;
					break;
				case XPLUS:
					cheek = 1;
					break;
				default:
					cheek = 100;
				}
			}else {
				switch(direction){
				case ZMINUS:
					cheek = 0;
					break;
				case ZPLUS:
					cheek = 1;
					break;
				default:
					cheek = 100;
				}
			}
		}
		if (usin instanceof Rainure) {
			Rainure rainure = (Rainure) usin;
			if(orientation == Orientation.VERTICAL) {
				cheek = 0;
				if(rainure.getXpos() == 0 )
				{
					cheek = 1;
				}else if(rainure.getXpos()+rainure.getLongeurext()== piece.getLongeurext()) {
					cheek=0;
				}else {
					cheek=-1;
				}
			}else if(orientation == Orientation.HORIZONTAL){
				cheek = 1;
				if(rainure.getYpos() == 0)
				{
					cheek = 1;
				}else if(rainure.getYpos()+rainure.getHauteurext()==piece.getHauteurext()) {
					cheek=0;
				}else {
					cheek=-1;
				}
			}else {
				cheek = 0;
				if(rainure.getZpos()==0)
				{
					cheek=1;
				}else if(rainure.getZpos()+rainure.getProfondeurext()==piece.getProfondeurext()) {
					cheek=0;
				}else {
					cheek=-1;
				}
			}
		}
		return cheek;
	}

}
