package supercad.structures;

import java.util.Iterator;
import java.util.Vector;

public class NodeIterator implements Iterator<Node> {
	
	Vector<Node> elements = new Vector<Node>();
	int index = 0;
	
	public NodeIterator(Node root) {
		traverse(root);
	}

	private void traverse(Node root) {
		elements.add(root);
		for(Node child: root.getChildren()) {
			traverse(child);
		}
	}

	@Override
	public boolean hasNext() {
		return elements.size() > index;
	}

	@Override
	public Node next() {
		return elements.get(index++);
	}

}
