package dressing.ui.model.project3d;

import javax.inject.Inject;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

import dressing.model.ModelPackageProject3D;
import dressing.model.ModelPackageProjectParent;
import dressing.model.Project3D;
import dressing.model.ProjectParent;



public class ModelPackageProject3DWizard extends Wizard{

	//L injection ne peut etre en marche que si on creer l objet avec contextfactory et non pas avec l objet new
	@Inject
	IEclipseContext  eclipsecontext;

	@Inject
	private EHandlerService handlerService;
	
	@Inject
	private ECommandService commandService;

	ModelPackageProjectParent root;
	ModelPackageProject3D project3d = new ModelPackageProject3D();
	public ModelPackageProject3DWizard () {
		setWindowTitle("Nouveau model package");		
	}

	@Override
	public void addPages() {
		
		addPage(new ModelPackageProjet3DWizardPage("ProjectPage",project3d));		
	}

	@Override
	public boolean performFinish() {
		
			if(root!=null)
			{
				root.addProject(project3d,false);
				//Sauvegarder l emplacemt du reportoire
				
				Preferences preferences = InstanceScope.INSTANCE.getNode("com.dressing");
				Preferences projectpref = preferences.node("project3d");
				projectpref.put("directory", project3d.getDirectory());
				try {
					preferences.flush();
				} catch (BackingStoreException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				return true;
			}
			return false;
	}	
	
	public void setRoot(ModelPackageProjectParent root) {
		this.root = root;
	}

@Override
public boolean canFinish() {
		IWizardPage[] pages = getPages();
		for (IWizardPage page : pages) {
			if (!page.isPageComplete()) {
				return false;
			}
		}
		return true;
}
}
