package dressing.ui;

import dressing.events.Event;
import dressing.model.DesignException;
import dressing.model.Kitchen;
import dressing.model.ProjectManager;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.scenes.Scene;
import gdxapp.scenes.SceneEvent;

public class RemoveObjectCommand implements ChangeCommand {
	
	
	public final static String label = SceneEvent.REMOVE_OBJECT_REQUEST.name();
	String name;
	String description;
	Object target;
	Scene scene;
	Kitchen kitchen;
	
	public RemoveObjectCommand(String name, String description, WorldObject target, Scene scene, Kitchen kitchen) {
		super();
		this.name = name;
		this.description = description;
		this.target = target;
		this.scene = scene;
		this.kitchen = kitchen;
	}
	
	public RemoveObjectCommand(String name, String description, Object target) {
		super();
		this.name = name;
		this.description = description;
		this.target = target;
		this.scene = ProjectManager.getManager().getCurrentScene();
		this.kitchen = ProjectManager.getManager().getCurrentKitchen();
	}

	@Override
	public void redo() {
		if(scene!=null && target!=null) {
			scene.removeWorldObject(target);
		}
	}

	@Override
	public void verify() {
		// TODO Auto-generated method stub

	}

	@Override
	public void undo() {
//		if(target instanceof KitchenElement && kitchen!=null) {
//			KitchenElement element = (KitchenElement) target;
//			try {
//				kitchen.addElement(element.getDesignObject());
//			} catch (DesignException e) {
//				e.printStackTrace();
//			}
//		}
//		scene.addActor(target, true);

	}

	public String getID() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Object getTarget() {
		return target;
	}

	public void setTarget(WorldObject target) {
		this.target = target;
	}

	public Scene getScene() {
		return scene;
	}

	public void setScene(Scene scene) {
		this.scene = scene;
	}

	public Kitchen getKitchen() {
		return kitchen;
	}

	public void setKitchen(Kitchen kitchen) {
		this.kitchen = kitchen;
	}

	@Override
	public void dispose() {
		name=null;
		description=null;
		target=null;
		scene=null;
		kitchen=null;
	}
	
	@Override
	public Event getEvent() {
		return new Event(label, target);
	}
	
	public String toString() {
		return label;
	}
}
