package dressing.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Base64;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class LicenseChecker {

	private final static String algorithm = "AES/CBC/PKCS5Padding";
	private static SecretKeySpec key;
	private static IvParameterSpec iv;
	private static boolean initialized = false;

	public static String getUUID() throws IOException {
		String OS = System.getProperty("os.name").toLowerCase();
		String cmd = null;
		if (OS.indexOf("win") >= 0) { // your code for windows OS.
			cmd = "wmic csproduct get UUID";
		} else if (OS.indexOf("mac") >= 0) { // your code for MAC OS.
			cmd = "system_profiler SPHardwareDataType | awk '/UUID/ { print $3; }'";
		} else if (OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0) { // your code for unix
																								// OS's
			cmd = "# cat /sys/class/dmi/id/product_uuid";
		} else {
			throw new RuntimeException("Operating System not suppported");
		}
		Process serialNbreProcess = Runtime.getRuntime().exec(cmd);
		BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(serialNbreProcess.getInputStream()));
		String uuid = "";
		String line = "";
		while ((line = bufferedReader.readLine()) != null) {
			uuid += line;
		}
		return uuid.replaceAll("[\\n\\t ]", "");
	}

	public static void init() throws IOException {
		
		File keyFile = new File(WorkspaceConfiguration.key);
        File paddingFile = new File(WorkspaceConfiguration.padding);

        String keyString = new String(Files.readAllBytes(keyFile.toPath()), Charset.defaultCharset());
        byte[] keyBites = Base64.getDecoder().decode(keyString);
        key = new SecretKeySpec(keyBites,"AES");

        String padding = new String(Files.readAllBytes(paddingFile.toPath()), Charset.defaultCharset());
        byte[] paddingBites = Base64.getDecoder().decode(padding);
        iv = new IvParameterSpec(paddingBites);
	}

	public static String decrypt(String algorithm, String cipherText, SecretKey key, IvParameterSpec iv)
			throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException,
			InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
		Cipher cipher = Cipher.getInstance(algorithm);
		cipher.init(Cipher.DECRYPT_MODE, key, iv);
		byte[] plainText = cipher.doFinal(Base64.getDecoder().decode(cipherText));
		return new String(plainText);
	}

	public static boolean hasValidLicense()
			throws InvalidKeyException, NoSuchPaddingException, NoSuchAlgorithmException,
			InvalidAlgorithmParameterException, BadPaddingException, IllegalBlockSizeException, IOException {
		
		if(!initialized)
			init();
		String path = System.getProperty("user.home");
		File licenseFile = new File(path + File.separator + "lic.lic");
		if (!licenseFile.exists())
			return false;

		String cipherText = new String(Files.readAllBytes(licenseFile.toPath()), Charset.defaultCharset());
		String decoded = decrypt(algorithm, cipherText, key, iv);

		boolean isValid = true;
		try {
			String[] info = decoded.split(";");
			String uuid = getUUID();
			if (!info[0].contentEquals(uuid))
				return false;
			LocalDate expirationDate = LocalDate.parse(info[1], DateTimeFormatter.BASIC_ISO_DATE);
			if (expirationDate.isBefore(LocalDate.now()))
				return false;
		} catch (Exception e) {
			isValid = false;
		}
		return isValid;
	}


}
