package api.mep;

import java.util.Objects;

import org.joml.Matrix4f;
import org.joml.Vector3f;

import api.graphics.geometry.ShapeDrawer;

public class Measure{

	private Vector3f v0;
	private Vector3f v1;
	private Vector3f o0;
	private Vector3f o1;
	private float value;
	
	private Matrix4f transform;
	
	public Measure(Vector3f v0, Vector3f v1) {
		this.v0 = v0;
		this.v1 = v1;
		o0 = new Vector3f(v0);
		o1 = new Vector3f(v1);
		value = v0.distance(v1);
	}
	
	public Vector3f getCenter() {
		return new Vector3f(v0).add(v1).mul(0.5f);
	}
	
	public Vector3f getV0() {
		return v0;
	}
	public void setV0(Vector3f v0) {
		this.v0 = v0;
	}
	public Vector3f getV1() {
		return v1;
	}
	public void setV1(Vector3f v1) {
		this.v1 = v1;
	}	
	
	
	public Vector3f getO0() {
		return o0;
	}

	public void setO0(Vector3f o0) {
		this.o0 = o0;
	}

	public Vector3f getO1() {
		return o1;
	}

	public void setO1(Vector3f o1) {
		this.o1 = o1;
	}

	public float getValue() {
		return value;
	}
	public void setValue(float value) {
		this.value = value;
	}
	
	
	public void draw(ShapeDrawer drawer) {
		
	}

	@Override
	public String toString() {
		return "Measure [v0=" + v0 + ", v1=" + v1 + ", value=" + value + ", transform=" + transform + "]";
	}

	public void translateBy(Vector3f translation) {
		v0.add(translation);
		v1.add(translation);
	}

	public void scaleBy(Vector3f scale) {
		v0.mul(scale);
		v1.mul(scale);
	}

	@Override
	public int hashCode() {
		return Objects.hash(transform, v0, v1, value);
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Measure other = (Measure) obj;
		
		Vector3f center = new Vector3f(v0).add(v1).mul(0.5f);
		Vector3f otherCenter = new Vector3f(other.getV0()).add(other.getV1()).mul(0.5f);
		if(center.distanceSquared(otherCenter) > 0.001f)
			return false;
		Vector3f dir =new Vector3f(v1).sub(v0);
		Vector3f otherDir = new Vector3f(v1).sub(v0);
		if(Math.abs(dir.dot(otherDir)/dir.lengthSquared() - 1) > 0.001f)
			return false;
		return true;
	}

	public float len() {
		return v0.distance(v1);
	}
	
	
	
	
	
	
	
	
	
}
