/*
 * Decompiled with CFR 0.152.
 */
package com.frs.supercad.parametric_model.api.core;

import com.frs.supercad.parametric_model.api.core.IParametricModelService;
import com.frs.supercad.parametric_model.api.core.ParametricModel;
import com.frs.supercad.parametric_model.api.core.ParametricModelLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={IParametricModelService.class}, immediate=true)
public class ParametricModelService
implements IParametricModelService {
    @Reference
    private ParametricModelLoader modelLoader;
    private HashSet<ParametricModel> models = new HashSet();

    @Activate
    void init() {
        System.out.println("paramteric model service ini");
    }

    @Override
    public List<ParametricModel> getAll() {
        return new ArrayList<ParametricModel>(this.models);
    }

    @Override
    public Optional<ParametricModel> findModelById(UUID id) {
        return this.models.stream().filter(m -> m.getId().equals(id)).findFirst();
    }

    @Override
    public Optional<ParametricModel> findModelByName(String name) {
        return this.models.stream().filter(m -> m.getName().equals(name)).findFirst();
    }

    @Override
    public void addModel(ParametricModel model) {
        this.models.add(model);
    }

    @Override
    public ParametricModel loadModel(String path) {
        ParametricModel model = null;
        try {
            try {
                model = this.modelLoader.loadModel(path);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (model != null) {
                    this.models.add(model);
                }
            }
        }
        finally {
            if (model != null) {
                this.models.add(model);
            }
        }
        return model;
    }
}

