/*
 * Decompiled with CFR 0.152.
 */
package com.frs.supercad.parametric_model.api.core;

import com.frs.supercad.parametric_model.api.core.ModelParameter;
import com.frs.supercad.parametric_model.api.core.ModelPart;
import com.frs.supercad.parametric_model.api.core.ParametricModel;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.osgi.service.component.annotations.Component;

@Component(service={ParametricModelLoader.class})
public class ParametricModelLoader {
    private ParametricModel loadingModel;

    public ParametricModel loadModel(String path) throws Exception {
        this.loadingModel = null;
        String src = this.loadSrc(path);
        JSONParser parser = new JSONParser();
        JSONObject json = (JSONObject)parser.parse(src);
        String name = (String)json.get((Object)"name");
        String modelID = (String)json.get((Object)"id");
        String modelType = (String)json.get((Object)"type");
        boolean knobbed = (Boolean)json.getOrDefault((Object)"knobbed", (Object)Boolean.TRUE);
        JSONArray parameters = (JSONArray)json.get((Object)"parameters");
        List<ModelParameter> params = this.parseParameters(parameters);
        JSONArray partsJSON = (JSONArray)json.get((Object)"parts");
        List<ModelPart> parts = this.parseParts(partsJSON);
        this.loadingModel = new ParametricModel();
        this.loadingModel.setName(name);
        this.loadingModel.setType(ParametricModel.ModelType.valueOf(modelType));
        this.loadingModel.setId(UUID.fromString(modelID));
        this.loadingModel.setParameters(params);
        this.loadingModel.setParts(parts);
        this.loadingModel.setPath(path);
        this.loadingModel.setSource(json);
        this.loadingModel.setKnobbed(knobbed);
        JSONObject transfromJson = (JSONObject)json.get((Object)"transform");
        this.loadTransform(transfromJson);
        return this.loadingModel;
    }

    private String loadSrc(String path) {
        String src = null;
        try {
            src = Files.readString(Path.of(path, new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return src;
    }

    private void loadTransform(JSONObject json) {
        Object translationSrc = json.get((Object)"translation");
        Object scaleSrc = json.get((Object)"scale");
        Object rotationSrc = json.get((Object)"rotation");
        if (translationSrc != null && translationSrc instanceof JSONArray) {
            float[] translation = this.parseDoubleArray((JSONArray)translationSrc);
            this.loadingModel.setTranslation(translation);
        }
        if (scaleSrc != null && scaleSrc instanceof JSONArray) {
            float[] scale = this.parseDoubleArray((JSONArray)scaleSrc);
            this.loadingModel.setScale(scale);
        }
        if (rotationSrc != null && rotationSrc instanceof JSONArray) {
            float[] rotation = this.parseDoubleArray((JSONArray)rotationSrc);
            this.loadingModel.setRotation(rotation);
        }
    }

    private List<ModelPart> parseParts(JSONArray partSrc) {
        ArrayList<ModelPart> parts = new ArrayList<ModelPart>();
        for (Object part : partSrc) {
            JSONObject partJSON = (JSONObject)part;
            String partName = (String)partJSON.get((Object)"name");
            String mtlRef = (String)partJSON.get((Object)"material");
            ModelPart partX = new ModelPart(partName, mtlRef, part.toString());
            parts.add(partX);
        }
        return parts;
    }

    private List<ModelParameter> parseParameters(JSONArray json) {
        ArrayList<ModelParameter> params = new ArrayList<ModelParameter>();
        for (Object parameterSrc : json) {
            ModelParameter param = this.parseParameter((JSONObject)parameterSrc);
            if (param == null) continue;
            params.add(param);
        }
        return params;
    }

    public ModelParameter parseParameter(JSONObject json) {
        String clazz = (String)json.get((Object)"type");
        String ref = (String)json.get((Object)"reference");
        String dsiplayName = (String)json.get((Object)"display_name");
        String emfKey = (String)json.get((Object)"emf_key");
        Object defaultValue = json.get((Object)"default_value");
        boolean implicit = (Boolean)json.getOrDefault((Object)"implicit", (Object)false);
        ModelParameter parameter = null;
        try {
            Class<?> type = ParametricModelLoader.getClass(clazz);
            if (defaultValue.getClass() == Double.class) {
                defaultValue = Float.valueOf(((Double)defaultValue).floatValue());
            }
            parameter = new ModelParameter(type, ref, dsiplayName, implicit, defaultValue);
            parameter.setEmfKey(emfKey);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return parameter;
    }

    private float[] parseDoubleArray(JSONArray doubleArray) {
        float[] converted = new float[doubleArray.size()];
        int i = 0;
        while (i < converted.length) {
            converted[i] = ((Double)doubleArray.get(i)).floatValue();
            ++i;
        }
        return converted;
    }

    private static Class<?> getClass(String name) throws ClassNotFoundException {
        switch (name) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        return Class.forName(name);
    }
}

