/*
 * Decompiled with CFR 0.152.
 */
package com.frs.supercad.parametric_model.api.core;

import com.frs.supercad.parametric_model.api.core.DeepPolyMesh;
import com.frs.supercad.parametric_model.api.core.IndexedMesh;
import com.frs.supercad.parametric_model.api.core.Mesh;
import com.frs.supercad.parametric_model.api.core.ModelParameter;
import com.frs.supercad.parametric_model.api.core.ModelPart;
import com.frs.supercad.parametric_model.api.core.ParametricModel;
import java.util.ArrayList;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.mozilla.javascript.engine.RhinoScriptEngineFactory;

public class ParametricModelCompiler {
    private ScriptEngine scriptEngine;
    private Bindings bindings;
    private ParametricModel model;
    private JSONParser parser;

    public ParametricModelCompiler() {
        this.init();
    }

    private void init() {
        this.scriptEngine = new RhinoScriptEngineFactory().getScriptEngine();
        this.parser = new JSONParser();
    }

    public void compileModel(ParametricModel model, Map<String, Object> args) {
        this.model = model;
        JSONObject json = model.getSource();
        this.bind(args);
        Object envJSON = json.get((Object)"env");
        if (envJSON != null) {
            this.prepareEnv((JSONArray)envJSON, args);
        }
        for (ModelPart partX : model.getParts()) {
            try {
                this.parsePart(partX);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void parsePart(ModelPart part) {
        try {
            JSONObject partJSON = (JSONObject)this.parser.parse(part.getSrc());
            JSONArray meshSrc = (JSONArray)partJSON.get((Object)"mesh");
            ArrayList<Mesh> meshes = this.parseMesh(meshSrc.toJSONString());
            part.setMeshes(meshes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<Mesh> parseMesh(String meshSrc) {
        for (String ref : this.bindings.keySet()) {
            String value = String.valueOf(this.bindings.get(ref));
            meshSrc = meshSrc.replace(ref, value);
        }
        ArrayList<Mesh> meshes = new ArrayList<Mesh>();
        try {
            JSONArray meshesJSON = (JSONArray)this.parser.parse(meshSrc);
            block8: for (Object meshJSONX : meshesJSON) {
                Mesh mesh = null;
                JSONObject meshJSON = (JSONObject)meshJSONX;
                Mesh.MESH_TYPE type = Mesh.MESH_TYPE.valueOf((String)meshJSON.get((Object)"type"));
                switch (type) {
                    case POLY: {
                        mesh = this.parsePoly(meshJSON);
                        break;
                    }
                    case ANNULAR_POLY: {
                        mesh = this.parseAnnularPoly(meshJSON);
                        break;
                    }
                    case QUADS: {
                        mesh = this.parseQuads(meshJSON);
                        break;
                    }
                    default: {
                        System.out.println("Unexpected value: " + String.valueOf((Object)type));
                        continue block8;
                    }
                }
                if (mesh == null) continue;
                meshes.add(mesh);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return meshes;
    }

    private Mesh parseQuads(JSONObject meshJSON) {
        JSONArray verticesJSON = (JSONArray)meshJSON.get((Object)"vertices");
        String ref = (String)meshJSON.get((Object)"ref");
        ArrayList<Float[]> vertices = new ArrayList<Float[]>();
        for (Object position : verticesJSON) {
            Float[] vertex = this.parseFloatArray((JSONArray)position);
            vertices.add(vertex);
        }
        int size = 3 * vertices.size();
        int c = 0;
        float[] vertexData = new float[size];
        for (Float[] vertex : vertices) {
            vertexData[c++] = vertex[0].floatValue();
            vertexData[c++] = vertex[1].floatValue();
            vertexData[c++] = vertex[2].floatValue();
        }
        JSONArray indicesJSON = (JSONArray)meshJSON.get((Object)"indices");
        int[] indices = this.parseIntegerArray(indicesJSON);
        IndexedMesh mesh = new IndexedMesh(ref, Mesh.MESH_TYPE.QUADS, vertexData, indices);
        this.bindings.put("$" + ref + "$", (Object)mesh.serialize());
        return mesh;
    }

    private Mesh parsePoly(JSONObject meshJSON) {
        String depthStr = (String)meshJSON.get((Object)"depth");
        float depth = 0.0f;
        try {
            Number depthX = (Number)this.scriptEngine.eval(depthStr);
            depth = depthX.floatValue();
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        JSONArray verticesJSON = (JSONArray)meshJSON.get((Object)"vertices");
        String ref = (String)meshJSON.get((Object)"ref");
        ArrayList<Float[]> vertices = new ArrayList<Float[]>();
        for (Object position : verticesJSON) {
            Float[] vertex = this.parseFloatArray((JSONArray)position);
            vertices.add(vertex);
        }
        int size = 2 * vertices.size();
        int c = 0;
        float[] vertexData = new float[size];
        for (Float[] vertex : vertices) {
            vertexData[c++] = vertex[0].floatValue();
            vertexData[c++] = vertex[1].floatValue();
        }
        DeepPolyMesh mesh = new DeepPolyMesh(ref, Mesh.MESH_TYPE.POLY, vertexData, null, depth);
        this.bindings.put("$" + ref + "$", (Object)mesh.serialize());
        return mesh;
    }

    private Mesh parseAnnularPoly(JSONObject meshJSON) {
        String depthStr = (String)meshJSON.get((Object)"depth");
        float depth = 0.0f;
        try {
            Number depthX = (Number)this.scriptEngine.eval(depthStr);
            depth = depthX.floatValue();
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        String ref = (String)meshJSON.get((Object)"ref");
        JSONArray polySrc = (JSONArray)meshJSON.get((Object)"poly");
        Object holeSrc = meshJSON.get((Object)"hole");
        ArrayList<Float[]> polyVertices = new ArrayList<Float[]>();
        for (Object position : polySrc) {
            Float[] vertex = this.parseFloatArray((JSONArray)position);
            polyVertices.add(vertex);
        }
        int size = 2 * polyVertices.size();
        int c = 0;
        float[] vertexData = new float[size];
        for (Float[] vertex : polyVertices) {
            vertexData[c++] = vertex[0].floatValue();
            vertexData[c++] = vertex[1].floatValue();
        }
        float[] holeVertices = null;
        try {
            JSONArray holeData = (JSONArray)this.parser.parse((String)holeSrc);
            holeVertices = new float[holeData.size()];
            int x = 0;
            while (x < holeData.size()) {
                holeVertices[x] = ((Number)holeData.get(x)).floatValue();
                ++x;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        DeepPolyMesh mesh = new DeepPolyMesh(ref, Mesh.MESH_TYPE.ANNULAR_POLY, vertexData, holeVertices, depth);
        this.bindings.put("$" + ref + "$", (Object)mesh.serialize());
        return mesh;
    }

    private void bind(Map<String, Object> args) {
        this.bindings = this.scriptEngine.createBindings();
        if (args == null) {
            for (ModelParameter param : this.model.getParameters()) {
                String value = String.valueOf(param.getValue());
                String ref = "$" + param.getRef() + "$";
                this.bindings.put(ref, (Object)value);
            }
        } else {
            for (ModelParameter param : this.model.getParameters()) {
                Object argsValue = args.get(param.getRef());
                String value = String.valueOf(argsValue == null ? param.getValue() : argsValue);
                String ref = "$" + param.getRef() + "$";
                this.bindings.put(ref, (Object)value);
            }
        }
    }

    public void prepareEnv(JSONArray env, Map<String, Object> out) {
        for (Object envar : env) {
            try {
                JSONObject variable = (JSONObject)envar;
                String ref = (String)variable.get((Object)"ref");
                String expr = (String)variable.get((Object)"expr");
                Object value = this.scriptEngine.eval(expr, this.bindings);
                String varRef = String.format("$%s$", ref);
                this.bindings.put(varRef, value);
                out.put(ref, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Float[] parseFloatArray(JSONArray position) {
        Float[] coords = new Float[position.size()];
        int i = 0;
        while (i < position.size()) {
            String str = (String)position.get(i);
            try {
                Number number = (Number)this.scriptEngine.eval(str, this.bindings);
                coords[i] = Float.valueOf(number.floatValue());
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return coords;
    }

    private int[] parseIntegerArray(JSONArray indicesJSON) {
        int[] coords = new int[indicesJSON.size()];
        int i = 0;
        while (i < indicesJSON.size()) {
            try {
                Number number = (Number)indicesJSON.get(i);
                coords[i] = number.intValue();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return coords;
    }
}

