/*
 * Decompiled with CFR 0.152.
 */
package com.frs.supercad.parametric_model.api.core;

import com.frs.supercad.parametric_model.api.core.ModelParameter;
import com.frs.supercad.parametric_model.api.core.ModelPart;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.json.simple.JSONObject;

public class ParametricModel {
    private String name;
    private UUID id;
    private String path;
    private ModelType type;
    private boolean knobbed;
    private List<ModelParameter> parameters;
    private transient JSONObject source;
    private List<ModelPart> parts;
    private float[] translation;
    private float[] scale;
    private float[] rotation;
    private float[] vertices;

    public Object getParameter(String ref) {
        Optional<ModelParameter> parameter = this.parameters.stream().filter(p -> p.getRef().equals(ref)).findFirst();
        if (parameter.isPresent()) {
            return parameter.get().getValue();
        }
        throw new IllegalArgumentException("model has no param with key " + ref);
    }

    public void setParameter(String ref, Object value) {
        Optional<ModelParameter> parameter = this.parameters.stream().filter(p -> p.getRef().equals(ref)).findFirst();
        if (!parameter.isPresent()) {
            throw new IllegalArgumentException("model has no param with key " + ref);
        }
        parameter.get().setValue(value);
    }

    public void addPart(ModelPart part) {
        if (this.parts == null) {
            this.parts = new ArrayList<ModelPart>();
        }
        this.parts.add(part);
    }

    public ParametricModel cpy() {
        ParametricModel copy = new ParametricModel();
        copy.setId(this.id);
        copy.setName(this.name);
        copy.setType(this.type);
        copy.setPath(this.path);
        copy.setSource(this.source);
        copy.setTranslation(this.translation);
        copy.setRotation(this.rotation);
        copy.setScale(this.scale);
        copy.setKnobbed(this.knobbed);
        ArrayList<ModelParameter> params = new ArrayList<ModelParameter>();
        this.parameters.stream().forEach(p -> {
            boolean bl = params.add(p.cpy());
        });
        copy.setParameters(params);
        ArrayList<ModelPart> parts = new ArrayList<ModelPart>();
        this.parts.forEach(p -> {
            boolean bl = parts.add(p.cpy());
        });
        copy.setParts(parts);
        return copy;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UUID getId() {
        return this.id;
    }

    public ModelType getType() {
        return this.type;
    }

    public void setType(ModelType type) {
        this.type = type;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<ModelParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ModelParameter> parameters) {
        this.parameters = parameters;
    }

    public List<ModelPart> getParts() {
        return this.parts;
    }

    public void setParts(List<ModelPart> parts) {
        this.parts = parts;
    }

    public JSONObject getSource() {
        return this.source;
    }

    public void setSource(JSONObject source) {
        this.source = source;
    }

    public float[] getVertices() {
        return this.vertices;
    }

    public void setVertices(float[] vertices) {
        this.vertices = vertices;
    }

    public float[] getTranslation() {
        return this.translation;
    }

    public void setTranslation(float[] translation) {
        this.translation = translation;
    }

    public float[] getScale() {
        return this.scale;
    }

    public void setScale(float[] scale) {
        this.scale = scale;
    }

    public float[] getRotation() {
        return this.rotation;
    }

    public void setRotation(float[] rotation) {
        this.rotation = rotation;
    }

    public boolean isKnobbed() {
        return this.knobbed;
    }

    public void setKnobbed(boolean knobbed) {
        this.knobbed = knobbed;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParametricModel other = (ParametricModel)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return "ParametricModel [name=" + this.name + ", id=" + String.valueOf(this.id) + ", path=" + this.path + ", type=" + String.valueOf((Object)this.type) + "]";
    }

    public static enum ModelType {
        DEEP_POLY,
        MESH,
        INDEXED_MESH;

    }
}

