/*
 * Decompiled with CFR 0.152.
 */
package com.frs.supercad.parametric_model.api.core;

import java.util.Arrays;

public class Mesh {
    protected String ref;
    protected MESH_TYPE type;
    protected float[] vertexData;
    private float[] holeVertexData;

    public Mesh(String ref, MESH_TYPE type, float[] vertexData) {
        this.ref = ref;
        this.type = type;
        this.vertexData = vertexData;
    }

    public Mesh(String ref, MESH_TYPE type, float[] vertexData, float[] holeData) {
        this(ref, type, vertexData);
        this.holeVertexData = holeData;
    }

    public String serialize() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(String.format("[ %.3f", Float.valueOf(this.vertexData[0])));
        int i = 1;
        while (i < this.vertexData.length) {
            strBuilder.append(String.format(", %.3f", Float.valueOf(this.vertexData[i])));
            ++i;
        }
        strBuilder.append("]");
        return strBuilder.toString();
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public MESH_TYPE getType() {
        return this.type;
    }

    public void setType(MESH_TYPE type) {
        this.type = type;
    }

    public float[] getVertexData() {
        return this.vertexData;
    }

    public void setVertexData(float[] vertexData) {
        this.vertexData = vertexData;
    }

    public float[] getHoleVertexData() {
        return this.holeVertexData;
    }

    public void setHoleVertexData(float[] holeVertexData) {
        this.holeVertexData = holeVertexData;
    }

    public String toString() {
        return "Mesh [ref=" + this.ref + ", type=" + String.valueOf((Object)this.type) + ", vertexData=" + Arrays.toString(this.vertexData) + "]";
    }

    public static enum MESH_TYPE {
        POLY,
        ANNULAR_POLY,
        QUADS;

    }
}

