package swt.test;
import org.eclipse.jface.viewers.*;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.*;
import java.util.ArrayList;
import java.util.List;

public class TableComboViewerSearchExample {

    private static class Item {
        String code;
        String label;

        Item(String code, String label) {
            this.code = code;
            this.label = label;
        }

        @Override
        public String toString() {
            return code + " - " + label;
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("TableComboViewer Search");
        shell.setLayout(new FillLayout());
        shell.setSize(400, 200);

        TableComboViewer viewer = new TableComboViewer(shell, SWT.NONE);
        TableCombo combo = viewer.getTableCombo();
        combo.defineColumns(2);
        combo.setDisplayColumnIndex(1); // show label as default

        // Sample data
        List<Item> items = new ArrayList<>();
        items.add(new Item("001", "Apple"));
        items.add(new Item("002", "Banana"));
        items.add(new Item("003", "Cherry"));
        items.add(new Item("004", "Date"));
        items.add(new Item("005", "Elderberry"));

        // Set content provider
        viewer.setContentProvider(ArrayContentProvider.getInstance());

        // Set label provider
        viewer.setLabelProvider(new ITableLabelProvider() {
            public String getColumnText(Object element, int columnIndex) {
                Item item = (Item) element;
                return columnIndex == 0 ? item.code : item.label;
            }

            public org.eclipse.swt.graphics.Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public void addListener(ILabelProviderListener listener) {}
            public void dispose() {}
            public boolean isLabelProperty(Object element, String property) { return false; }
            public void removeListener(ILabelProviderListener listener) {}
        });

        viewer.setInput(items);
//        SWT.Selection
        // Add filtering based on text input
        combo.getTextControl().addKeyListener(new KeyAdapter() {
            @Override
            public void keyReleased(KeyEvent e) {
                // Ignore arrow keys, Enter, etc.
                if (e.keyCode == SWT.ARROW_UP || e.keyCode == SWT.ARROW_DOWN ||
                    e.keyCode == SWT.CR || e.keyCode == SWT.LF || e.keyCode == SWT.ESC  || e.keyCode == SWT.CR
                    || e.keyCode == SWT.KEYPAD_CR) {
                    return;
                }
                combo.getArrowControl().notifyListeners(SWT.Selection, new Event());

                String searchText = combo.getText().toLowerCase();
                viewer.resetFilters();
                if (!searchText.isEmpty()) {
                    viewer.addFilter(new ViewerFilter() {
                        @Override
                        public boolean select(Viewer viewer, Object parentElement, Object element) {
                            Item item = (Item) element;
                            return item.label.toLowerCase().contains(searchText)
                                || item.code.toLowerCase().contains(searchText);
                        }
                    });
                }

                viewer.refresh();
                combo.setVisible(true);
                combo.setTableVisible(true);
                combo.setVisibleItemCount(10);
            }
        });

        shell.open();
        while (!shell.isDisposed()) {
            if (!display.readAndDispatch()) display.sleep();
        }
        display.dispose();
    }
}