package supercad.persistence.databinding;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import com.badlogic.gdx.utils.Array.ArrayIterable;
import com.google.common.collect.MapMaker;

import dressing.model.persistence.dpos.DPO;
import dressing.model.persistence.mappers.MapperProvider;
import supercad.runtime.ReflectionUtils;
import supercad.xml.XmlNode;

public class XmlUnmarshaller {

	public Object unmarshall(XmlNode node, Class hint) {
		Class<? extends DPO> persistableForm = MapperProvider.getInstance().getPersistableType(hint);
		var serializedType = node.getAttr("type");
		if(persistableForm == null && serializedType != null) {
			try {
				var clazz = Class.forName(serializedType);
				if(clazz!= null && DPO.class.isAssignableFrom(clazz)) {
					persistableForm = (Class<? extends DPO>) clazz;
				}
			}catch (Exception e) {
				e.printStackTrace();
			}
		}
		if(persistableForm != null)
			hint = persistableForm;
		if (isSimpleTypeNode(node, hint)) {
			if (isValueNode(node)) {
				return getValue(node, hint);
			} else {
				return unmarshallObject(node, hint);
			}

		} else {
			if (isMapNode(node, hint)) {
				return unmarshallMap(node, hint);
			} else {
				return unmarshallArray(node, hint);
			}
		}
	}
	


	private Object[] unmarshallArray(XmlNode node, Class hint) {
		ArrayList<Object> objects = new ArrayList<Object>();
		Class type = null;
		if(hint != null && hint.isArray())
			type = hint.componentType();
		for(XmlNode child: node.getChildren()) {
			objects.add(unmarshall(child, type));
		}
		Object[] array = new Object[0];
		return objects.toArray(array);
	}



	private Map unmarshallMap(XmlNode node, Class hint) {
		if(node.getFirstChild().getName().equals("entry"))
			return MapUnmarshaller.unmarshallMapAsEntrySet(node, this, hint);
		return MapUnmarshaller.unmarshallMapBaseonAttribute(node, this, hint);
	}

	private boolean isMapNode(XmlNode node, Class hint) {
		Class clazz = hint;
		if(clazz == null || clazz == Object.class)
		try {
			String clazzName = node.getAttr("type");
			clazz = ReflectionUtils.getClass(clazzName);
		} catch (Exception e) {
			return false;
		}
		return Map.class.isAssignableFrom(clazz);
	}

	public static boolean isSimpleTypeNode(XmlNode node, Class hint) {
		try {
			Class clazz = hint == null?ReflectionUtils.getClass(node.getAttr("type")):hint;
			return ReflectionUtils.isSimpleType(clazz);
		} catch (Exception e) {
			return false;
		}
	}

	public static boolean isValueNode(XmlNode node) {
		return node.getChildren().isEmpty();
	}

	public static Object getValue(XmlNode node, Class hint) {
		Class clazz = hint;
		if(clazz == null || clazz == Object.class) {
			String type = node.getAttr("type");
			try {
				clazz = ReflectionUtils.getClass(type);
			}catch (Exception e) {
				e.printStackTrace();
			}
		}
		CustomValueMapper mapper = MapperProvider.getInstance().getValueTypeMapper(clazz);
		return mapper.read(node.getValue(), clazz);
	}

	private Object unmarshallObject(XmlNode node, Class typeHint) {
		Class clazz = typeHint == null?TypeRegister.getType(node):typeHint;
		Object instance = null;
		if (clazz == null)
			return null;
		try {
			instance = clazz.getConstructor().newInstance();
			for (XmlNode child : node.getChildren()) {
				try {
					setField(instance, child);
				}catch (Exception e) {
					e.printStackTrace();
					continue;
				}
			}
		} catch (Exception e) {
			e.printStackTrace();

		}
		if(instance instanceof DPO)
			instance = ((DPO) instance).get();
		return instance;
	}

	private void setField(Object parent, XmlNode fieldNode) {
		Field field = TypeRegister.getField(parent.getClass(), fieldNode.getName());
		if(field == null) {
			System.err.println("could not find field " + fieldNode.getName());
			return;
		}
		Object fieldValue = unmarshall(fieldNode, field.getType());
		if(fieldValue != null) {
			if(fieldValue instanceof DPO)
				fieldValue = ((DPO) fieldValue).get();
			try {
				if (!field.trySetAccessible()) {
					ReflectionUtils.findSetter(field);
				} else {
					Class componentType = field.getType().getComponentType();
					if(componentType == null)
						componentType = Object.class;
					fieldValue = castValue(fieldValue,field.getType(), componentType);
					field.set(parent, fieldValue);
				}
			} catch (Exception e) {
				e.printStackTrace();
			} 
		}
		
	}

	private Object castValue(Object value, Class<?> target, Class componentType) {
		if(value.getClass() == target)
			return value;
		Class valueClass = value.getClass();
		if(!ReflectionUtils.isSimpleType(valueClass)) {
			if(!Map.class.isAssignableFrom(target)){
				List list = ReflectionUtils.getList(value, componentType);
				if(List.class.isAssignableFrom(target)) {
					return list;
				}else {
					Object array = Array.newInstance(componentType, list.size());
					int index = 0;
					for(Object element: list) {
						Array.set(array, index++, element);
					}
					return array;
				}
			}
		}else if(valueClass.getName()=="java.lang.String"){
			if(target.getName()=="long") {
				value=Long.valueOf((String) value);
			}
			
		}
		return value;
	}

}
