package supercad.graphics;

import java.io.File;
import java.util.ArrayList;

import dressing.io.IOUtilities;
import gdxapp.shaders.PbrMaterial;

public class Exportmtl {

	StringBuilder MtlText = new StringBuilder();

	public String exportmtl(ArrayList<PbrMaterial> mtlList, String outputDirectory) {
		for (PbrMaterial material : mtlList) {

			if (material.getName() != null) {
				MtlText.append(String.format("newmtl %s \n", material.getName()));
				MtlText.append(String.format("illum 2 \n"));
				if (material.getAlbedo() != null) {
					MtlText.append(String.format("Kd  %s  %s  %s \n", material.getAlbedo().x, material.getAlbedo().y,
							material.getAlbedo().z));

				}
				if (material.getAlbedoMapPath() != null) {

					MtlText.append(String.format("map_Kd %s \n ", new File(material.getAlbedoMapPath()).getName()));

				}
				MtlText.append(String.format("d  %s \n ", material.getOpacity()));
				MtlText.append(String.format("Pr  %s \n ", material.getRoughness()));
				MtlText.append(String.format("Pm  %s \n ", material.getMetalness()));



				if (material.getMetalnessMapPath() != null) {
					MtlText.append(String.format("map_Pm  %s \n ", new File(material.getMetalnessMapPath()).getName()));
				}
				if (material.getRoughnessMapPath() != null) {
					MtlText.append(String.format("map_Pr  %s \n ", new File(material.getRoughnessMapPath()).getName()));
				}
				if (material.getNormalMapPath() != null) {
					MtlText.append(String.format("map_Kn  %s \n ", new File(material.getNormalMapPath()).getName()));
				}
				if (material.getEmissive() != null) {
					MtlText.append(String.format("Ke  %s  %s  %s \n", material.getEmissive().x, material.getEmissive().y,
							material.getEmissive().z));

				}
			}

		}
		return MtlText.toString();
	}



}
