package supercad.eclipse.service;

import java.lang.reflect.Field;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;


public class OSGIUtilities {

    private BundleContext bundleContext;
    
    private static OSGIUtilities instance;

   

    /**
     * Injects an OSGi service into a field of an unmanaged object.
     * Note: This creates a strong reference to the service.
     */
    public <T> void injetcService(Object obj, Field field, Class<? extends T> serviceClass) {
        if (bundleContext == null) {
            throw new IllegalStateException("OSGIUtilities not yet initialized by e4 DI.");
        }

        ServiceReference<T> serviceRef = (ServiceReference<T>) bundleContext.getServiceReference(serviceClass);
        if (serviceRef != null) {
            T serviceInstance = bundleContext.getService(serviceRef);
            if (serviceInstance != null) {
                try {
                    field.setAccessible(true);
                    field.set(obj, serviceInstance);
                } catch (IllegalArgumentException | IllegalAccessException e) {
                    e.printStackTrace();
                    bundleContext.ungetService(serviceRef);
                }
            }
        }
    }
    
    
    public <T> void injetcService(Object obj, String fieldName) {
        if (bundleContext == null)
            throw new IllegalStateException("OSGIUtilities not yet initialized by e4 DI.");
        Field field = null;
		try {
			field = obj.getClass().getDeclaredField(fieldName);
		} catch (NoSuchFieldException | SecurityException e) {
			e.printStackTrace();
		}
        if(field == null)
        	return;
        var type = field.getType();
        injetcService(obj, field, type);
    }
    
    

    public BundleContext getBundleContext() {
		return bundleContext;
	}



	public void setBundleContext(BundleContext bundleContext) {
		this.bundleContext = bundleContext;
	}



	public static OSGIUtilities getInstance() {
		if(instance == null)
			instance = new OSGIUtilities();
        return instance;
    }
}