package supercad.api.controller;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpRequest.BodyPublishers;
import java.net.http.HttpResponse.BodyHandlers;
import java.time.LocalDateTime;
import java.util.UUID;
import java.util.zip.ZipOutputStream;

import org.json.simple.JSONObject;

import com.ibm.icu.util.LocaleData;

import dressing.config.WorkspaceConfiguration;
import dressing.io.IOUtilities;
import dressing.model.SuperCadProject;
import supercad.api.dto.CadProjectDTO;
import supercad.api.http.MultiPartBodyBuilder;

public class ProjectController {

	private HttpClient client;
	
	public void upload(SuperCadProject project) throws Exception{
		String dirPath = project.getProjectDirectory();
		File zip = new File(WorkspaceConfiguration.APP_DATA + File.separator + "tmp" + File.separator + project.getName() + ".zip");
		
		zip.getParentFile().mkdirs();
		
		zip.createNewFile();
		zip.setWritable(true);
		zip.setReadable(true);
		zip.setExecutable(true);
		FileOutputStream fos = new FileOutputStream(zip);
		ZipOutputStream zipStream = new ZipOutputStream(fos);
		IOUtilities.zipFile(new File(project.getProjectDirectory()), project.getName(), zipStream);
		zipStream.close();
		fos.close();
		CadProjectDTO dto = new CadProjectDTO(project);
		JSONObject json = dto.json();
		MultiPartBodyBuilder bodyBuilder = new MultiPartBodyBuilder();
		bodyBuilder.file(zip).metaData(json).build();
		System.err.println(bodyBuilder.getBody());
		this.client = HttpClient.newHttpClient();
		URI uri;
		uri = new URI("http://localhost:8080/file/uploads");
		HttpRequest request = HttpRequest.newBuilder()
				.uri(uri)
				.header("Content-Type", "multipart/form-data; boundary=" + bodyBuilder.getBoundary())
				.POST(BodyPublishers.ofString(bodyBuilder.getBody()))
				.build();
		HttpResponse response =  client.send(request, BodyHandlers.ofString());
		System.out.println(response.statusCode() + ":" + response.body());
		
	}
	
	
	public static void main(String...strings) {
		ProjectController projectController = new ProjectController();
		SuperCadProject project = new SuperCadProject();
		project.setId(UUID.randomUUID());
		project.setCreationDate(LocalDateTime.now());
		project.setCommercial("Imed");
		project.setName("Ali Ben Salah");
		project.setProjectDirectory("C:\\ProgramData\\supercad\\projects\\demo");
		try {
			projectController.upload(project);
		}catch (Exception e) {
			e.printStackTrace();
		}
	}
}
