package geometry;

import java.util.ArrayList;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;

public interface Shape {
	
	void draw(ShapeRenderer shapeRenderer,Color color);

    ArrayList<Vector2> getVertices();

    Vector2 getlastVertex();

	void scale(Vector2 scale);
	
	Shape cpy();

	float distanceTo(Vector2 position);
	
	Vector2 projectPoint(Vector2 point);
	
	Object select(Vector2 position);
	
	int getWinding();
		
	void setWinding(int winding);
}
