package gdxapp.ui;

import java.io.File;
import java.nio.file.Path;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton.ImageButtonStyle;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;

import dressing.config.WorkspaceConfiguration;

public class InMemorySkinService {

    private static InMemorySkinService instance;
    private final Skin skin;
    private Color hovered;
   

    private InMemorySkinService() {
        skin = new Skin();

        String root = Path.of(WorkspaceConfiguration.UI_SKIN).getParent().toString() + File.separator;
        // --- Chevron icons ---
        skin.add("icon-up-chevron", new TextureRegion(new Texture(root +  "top_chevron-24.png")));
        skin.add("icon-down-chevron", new TextureRegion(new Texture(root + "down_chevron.png")));
        skin.add("icon-left-chevron", new TextureRegion(new Texture(root + "left_chevron.png")));
        skin.add("icon-right-chevron", new TextureRegion(new Texture(root + "right_chevron.png")));
        
        hovered = new Color(0.8f, 0.8f, 1.0f, 0.5f);
        // --- Create ImageButtonStyles ---
        createChevronStyle("up-chevron", "icon-up-chevron");
        createChevronStyle("down-chevron", "icon-down-chevron");
        createChevronStyle("left-chevron", "icon-left-chevron");
        createChevronStyle("right-chevron", "icon-right-chevron");
    }

    private void createChevronStyle(String styleName, String iconName) {
        ImageButtonStyle style = new ImageButtonStyle();
        TextureRegionDrawable  base =  (TextureRegionDrawable) skin.getDrawable(iconName);
        style.imageUp = base;
        style.imageOver = new TextureRegionDrawable(base);
        style.imageDown = new TextureRegionDrawable(base);

        skin.add(styleName, style);
    }

    public static InMemorySkinService getInstance() {
        if (instance == null) {
            instance = new InMemorySkinService();
        }
        return instance;
    }

    public Skin getSkin() {
        return skin;
    }

    public ImageButton createButton(String styleName) {
        return new ImageButton(skin, styleName);
    }

    public void dispose() {
        skin.dispose();
    }
}
