package gdxapp.screens.wall;

import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.TextField.TextFieldFilter;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import dressing.graphics.shapes2d.Line;
import dressing.mathutils.Surface;
import dressing.model.ProjectManager;
import gdxapp.Commun.AbstractScreen;
import gdxapp.Commun.GroupSelection;
import gdxapp.assets.AssetFont;
import gdxapp.assets.AssetsTextures;
import gdxapp.assets.DrawingHelper;
import gdxapp.object3d.FullScreenActor;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.WorldObject;
import gdxapp.scenes.Scene;
import gdxapp.ui.CursorProvider;

import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;

public class OnSurfacePositioner extends FullScreenActor {

	private final static String TAG = OnSurfacePositioner.class.getName();

	private Line leftAnchor;
	private Line rightAnchor;
	private Line topAnchor;
	private Line bottomAnchor;
	
	private float leftValue;
	private float rightValue;
	private float topValue;
	private float bottomValue;

	private Window anchorWindow;
	private Line selectedAnchor;
	private float selectedValue;
	private static OnSurfacePositioner positioner = new OnSurfacePositioner();
	TextField tf;
	private Object2D subject;
	private InputListener inputListener;
	private Vector2 lastKonwnPosition;
	private Vector2 lastKnowSize;
	private boolean waitUserInput = false;
	
	private SurfaceController controller;

	private final Vector2 mouseLocation = new Vector2();


	private OnSurfacePositioner() {
		leftAnchor = new Line();
		rightAnchor = new Line();
		topAnchor = new Line();
		bottomAnchor = new Line();
		createInputListener();
	}
	
	public void begin() {
		onCameraChanged();
	}

	private void createInputListener() {
		this.inputListener = new InputListener() {
			@Override
			public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
				if(waitUserInput)
					return true;    //stop propagating the event
				if (subject == null )
					return false;
				Vector2 stageCoords = new Vector2(x,y);
				boolean handled = false;
				if (button == Input.Buttons.LEFT ) {
					if (selectedAnchor != null) {
						if (anchorWindow == null) {
							createAnchorWindow();
						} else {
							String value = String.valueOf(Math.round(selectedValue * 0.1f));
							tf.setText(value);
						}
						getStage().addActor(anchorWindow);
						anchorWindow.setPosition(stageCoords.x, stageCoords.y);
						anchorWindow.setVisible(true);
						getStage().setKeyboardFocus(tf);
						waitUserInput = true;
						handled = true;
					} else {
						handled = selectedAnchor != null;
					}
				}
				return handled;
			}

			@Override
			public boolean mouseMoved(InputEvent event, float x, float y) {
				if(!waitUserInput) {
					mouseLocation.set(x, y);
					detectSelectedAnchor();
				}
				
				return false;
			}
			
			
		};
		addListener(inputListener);
	}

	public void calculateAnchors() {
		
		if (subject == null || subject.getStage() == null)
			return;
		
		Vector2 currentSize = new Vector2(subject.getWidth(), subject.getHeight());
		Vector2 currentPosition = new Vector2(subject.getX(), subject.getY());
		
		boolean sizeChanged = lastKnowSize == null || !currentSize.epsilonEquals(lastKnowSize);
		boolean positionChanged = lastKonwnPosition == null || !currentPosition.epsilonEquals(lastKonwnPosition);
		if(sizeChanged || positionChanged) {
			Stage subjectStage = subject.getStage();
			Vector2 topCenter = new Vector2(subject.getX() + subject.getWidth() / 2, subject.getY() + subject.getHeight());
			Vector2 leftCenter = new Vector2(subject.getX(), subject.getY() + subject.getHeight() / 2f);
			Vector2 bottomCenter = new Vector2(subject.getX() + subject.getWidth() / 2, subject.getY());
			Vector2 rightCenter = new Vector2(subject.getX() + subject.getWidth(), subject.getY() + subject.getHeight() / 2);
			
			float surfaceHeight = controller.getSurface().getHeight();
			float surfaceLength = controller.getSurface().getLength();
			
			Vector2 top = new Vector2(topCenter.x, surfaceHeight);
			Vector2 left = new Vector2(0, leftCenter.y);
			Vector2 bottom = new Vector2(bottomCenter.x, 0);
			Vector2 right = new Vector2(surfaceLength, rightCenter.y);
			
			leftValue = left.dst(leftCenter);
			rightValue = right.dst(rightCenter);
			topValue = top.dst(topCenter);
			bottomValue = bottom.dst(bottomCenter);
			
			getStage().screenToStageCoordinates(subjectStage.stageToScreenCoordinates(top));
			getStage().screenToStageCoordinates(subjectStage.stageToScreenCoordinates(left));
			getStage().screenToStageCoordinates(subjectStage.stageToScreenCoordinates(bottom));
			getStage().screenToStageCoordinates(subjectStage.stageToScreenCoordinates(right));

			getStage().screenToStageCoordinates(subjectStage.stageToScreenCoordinates(topCenter));
			getStage().screenToStageCoordinates(subjectStage.stageToScreenCoordinates(leftCenter));
			getStage().screenToStageCoordinates(subjectStage.stageToScreenCoordinates(bottomCenter));
			getStage().screenToStageCoordinates(subjectStage.stageToScreenCoordinates(rightCenter));
			
			leftAnchor.setV0(left);
			leftAnchor.setV1(leftCenter);

			bottomAnchor.setV0(bottom);
			bottomAnchor.setV1(bottomCenter);

			rightAnchor.setV0(right);
			rightAnchor.setV1(rightCenter);

			topAnchor.setV0(top);
			topAnchor.setV1(topCenter);
			
			lastKnowSize = currentSize;
			lastKonwnPosition = currentPosition;
		}

	}

	@Override
	public void draw(Batch batch, float parentAlpha) {
		querySubject();
		if (subject != null) {
			Color color = Color.BLACK;
			DrawingHelper.drawCutLine(leftAnchor.getV0(), leftAnchor.getV1(), batch, Color.BLUE, 1, 6, 3);
			DrawingHelper.drawCutLine(bottomAnchor.getV0(), bottomAnchor.getV1(), batch, Color.BLUE, 1, 6,3);
			DrawingHelper.drawCutLine(rightAnchor.getV0(), rightAnchor.getV1(), batch, Color.BLUE, 1, 6, 3);
			DrawingHelper.drawCutLine(topAnchor.getV0(), topAnchor.getV1(), batch, Color.BLUE, 1, 6, 3);

			String value = String.valueOf(Math.round(leftValue * 0.1f));
			AssetFont.getInstance().getSmallFont().drawUnscaled(batch, value, leftAnchor.getCenter().x, leftAnchor.getCenter().y,
					0, 0, 0, color);
			value = String.valueOf(Math.round(bottomValue * 0.1f));
			AssetFont.getInstance().getSmallFont().drawUnscaled(batch, value, bottomAnchor.getCenter().x, bottomAnchor.getCenter().y,
					0, 0, 0, color);
			value = String.valueOf(Math.round(rightValue * 0.1f));
			AssetFont.getInstance().getSmallFont().drawUnscaled(batch, value, rightAnchor.getCenter().x, rightAnchor.getCenter().y,
					0, 0, 0, color);
			value = String.valueOf(Math.round(topValue * 0.1f));
			AssetFont.getInstance().getSmallFont().drawUnscaled(batch, value, topAnchor.getCenter().x, topAnchor.getCenter().y,
					0, 0, 0, color);
			if (selectedAnchor != null)
				DrawingHelper.drawLine(selectedAnchor.getV0(), selectedAnchor.getV1(), batch, Color.RED, 2);

		}
	}

	public void querySubject() {
		WorldObject selection = (WorldObject) GroupSelection.getInstance().getFirstElement();
		if (selection != null) {
			var selection2D = controller.getObject(selection);
				if (subject != selection2D) {
					subject = selection2D;
				}
				calculateAnchors();
		} else {
			subject = null;
			lastKonwnPosition = null;
			lastKnowSize = null;
		}
	}

	public void moveSubject(float amount) {
		amount = amount * controller.getSurface() .getScale();
		if (selectedAnchor == leftAnchor) {
			subject.setX(amount);
		}
		if (selectedAnchor == rightAnchor) {
			subject.setX(controller.getSurface().getLength() - subject.getWidth() - amount);
		}
		if (selectedAnchor == topAnchor) {
			subject.setY(controller.getSurface().getHeight() - subject.getHeight() - amount);
		}
		if (selectedAnchor == bottomAnchor) {
			subject.setY(amount);
		}
		if (subject.getWorldObject().isConstraint()) {
			SurfaceController controller = (SurfaceController) ((AbstractScreen) Scene.game.getScreen())
					.getController();
			Vector3 center = new Vector3(subject.getAbsoluteOrigin(), 0)
					.mul(controller.getSurface().getSurfaceToWorldTransform());
			ProjectManager.getManager().getCurrentScene().addConstraint(subject.getWorldObject(), center);
		}
	}

	public void detectSelectedAnchor() {
		querySubject();
		if(subject == null)
			return;
		selectedAnchor = null;
		float t = mouseLocation.dst(topAnchor.getCenter());
		float l = mouseLocation.dst(leftAnchor.getCenter());
		float b = mouseLocation.dst(bottomAnchor.getCenter());
		float r = mouseLocation.dst(rightAnchor.getCenter());
		float shortestDistance = Math.min(Math.min(t, b), Math.min(l, r));
		if (shortestDistance < 10) {
			if (shortestDistance == t) {
				selectedAnchor = topAnchor;
				selectedValue = topValue;
			} else if (shortestDistance == b) {
				selectedAnchor = bottomAnchor;
				selectedValue = bottomValue;
			} else if (shortestDistance == l) {
				selectedAnchor = leftAnchor;
				selectedValue = leftValue;
			} else {
				selectedAnchor = rightAnchor;
				selectedValue = rightValue;
			}
			CursorProvider.getInstance().useHand();
		} else {
			selectedAnchor = null;
			CursorProvider.getInstance().setDefault();

		}
	}

	public Object2D getSubject() {
		return subject;
	}

	public void setSubject(Object2D subject) {
		if (subject != this.subject) {
			this.subject = subject;
			calculateAnchors();
		}
	}

	public static OnSurfacePositioner getPositioner() {
		return positioner;
	}

	private void createAnchorWindow() {
		anchorWindow = new Window("", AssetsTextures.getInstance().getSkin());
		anchorWindow.setSize(200, 150);
		tf = new TextField("", AssetsTextures.getInstance().getSkin());
		tf.setTextFieldFilter(new TextFieldFilter.DigitsOnlyFilter());
		if (selectedAnchor != null) {
			String value = String.valueOf(Math.round(selectedValue * 0.1f));
			tf.setText(value);
		}
		TextButton tb = new TextButton("OK", AssetsTextures.getInstance().getSkin());
		tb.addListener(new ChangeListener() {

			@Override
			public void changed(ChangeEvent event, Actor actor) {
				try {
					String value = (String) tf.getText();
					moveSubject(Float.valueOf(value) * 0.001f);
				} catch (Exception e) {
					e.printStackTrace();
				} finally {
					anchorWindow.setVisible(false);
					tf.setText("");
					anchorWindow.remove();
					waitUserInput = false;
				}
			}

		});
		Table content = new Table();
		content.add(tf);
		content.row();
		content.add(tb);
		anchorWindow.add(content);
		anchorWindow.setVisible(true);
		getStage().addActor(anchorWindow);
	}

	public SurfaceController getController() {
		return controller;
	}

	public void setController(SurfaceController controller) {
		this.controller = controller;
	}
}
