package gdxapp.object3d;

import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder;
import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder.VertexInfo;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import dressing.mathutils.MathUtilities;
import gdxapp.shaders.PbrMaterial;

public class IndexedMeshBuilder {
	
	private MeshPartBuilder partBuilder;

	//, vertices, size, transform, material, modelBuilder
	public void buildQuads(String partName, Vector3[] vertices, int[] indices, Vector3 size, Matrix4 transform, PbrMaterial material, ModelBuilder modelBuilder) {
		
		Matrix3 rotationTransform = MathUtilities.extractRotation(transform);
		Node node = modelBuilder.node();
		node.id = partName;
		int attrs = VertexAttributes.Usage.Position | VertexAttributes.Usage.Normal | VertexAttributes.Usage.TextureCoordinates;
		this.partBuilder = modelBuilder.part(partName, GL20.GL_TRIANGLES, attrs, material);
		for(int i = 0; i< indices.length; i+= 4) {
			Vector3 v0 = vertices[indices[i]];
			Vector3 v1 = vertices[indices[i + 1]];
			Vector3 v2 = vertices[indices[i + 2]];
			Vector3 v3 = vertices[indices[i + 3]];
			Vector3 normal = v1.cpy().sub(v0).crs(v2.cpy().sub(v0)).nor();
			normal.mul(rotationTransform);
			Vector2[] uvs = {new Vector2(v0.x, v0.y).add(size.x, size.y),
							new Vector2(v1.x, v1.y).add(size.x, size.y),
							new Vector2(v2.x, v2.y).add(size.x, size.y),
							new Vector2(v3.x, v3.y).add(size.x, size.y)};
			VertexInfo[] infos = { new VertexInfo().setPos(v0.cpy().mul(transform)).setNor(normal).setUV(uvs[0]),
								   new VertexInfo().setPos(v1.cpy().mul(transform)).setNor(normal).setUV(uvs[1]),
								   new VertexInfo().setPos(v2.cpy().mul(transform)).setNor(normal).setUV(uvs[2]),
								   new VertexInfo().setPos(v3.cpy().mul(transform)).setNor(normal).setUV(uvs[3]),
							};
			partBuilder.triangle(infos[0], infos[1], infos[2]);
			partBuilder.triangle(infos[2], infos[3], infos[0]);
		}
	}
}
