package gdxapp.fabs3d;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.frs.supercad.parametric_model.api.core.IParametricModelService;
import com.frs.supercad.parametric_model.api.core.ParametricModel;
import com.frs.supercad.parametric_model.api.core.ParametricModelCompiler;
import com.frs.supercad.parametric_model.api.core.ParametricModelLoader;
import com.frs.supercad.parametric_model.api.core.ParametricModelService;

import gdxapp.object3d.ParamertricModelFactory;
import gdxapp.object3d.PolygonBuilder;
import gdxapp.shaders.PbrMaterial;
import param.MechanicPublicParam;
import supercad.eclipse.service.OSGIUtilities;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;

import org.eclipse.swt.widgets.Display;

import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;

public class FacadeCreator {
	
	private  ParamertricModelFactory factory = new ParamertricModelFactory(new ParametricModelCompiler());
	private IParametricModelService modelService;
	private ModelBuilder modelBuilder;
	
	
		
	public FacadeCreator() {
		OSGIUtilities.getInstance().injetcService(this, "modelService");
	}

	public void createFacade(Planche planche,ModelBuilder modelBuilder) {
		this.modelBuilder = modelBuilder;
		var model = planche.getKitchenElement().getFacadeModel(planche.getPiece2D().getID());
		if(model == null) {
			createSimpleFacade(planche, modelBuilder);
		}else {
			var bluePrint = modelService.findModelById(model.getId());
			if(bluePrint.isEmpty())
				return;
			model.setSource(bluePrint.get().getSource());
			createCustomFacade(planche, model);
		}

	}
	
	private void createCustomFacade(Planche planche, ParametricModel model) {
		HashMap<String, Object> args = new HashMap<String, Object>();
		for(var param: model.getParameters()) {
			args.put(param.getRef(), param.getValue());
			var emfKey = param.getEmfKey();
			if(emfKey!= null) {
				try {
					var emfParam =  planche.getPiece2D().getMechanicDesignDefinition().getPublicParam(emfKey);
					if(emfParam != null) {
						Object value = null;
						if(Number.class.isAssignableFrom(param.getType()))
							value = ((Number)param.getValue()).floatValue() * 1000;
						final Object fvalue = value;
						Display.getDefault().asyncExec(() -> {
							emfParam.setDefaultvalue(String.format("%.0f", fvalue));
						});
					}
				} catch (Exception e) {
					e.printStackTrace();
				}				
			}
		}
		addImplicitArgs(planche, args);
		var modelType = model.getType();
		
		switch (modelType) {
		case DEEP_POLY:
			factory.buildDeepPoly(model, args, modelBuilder, planche.getTransform().cpy().inv());		
			break;
		case INDEXED_MESH:
			factory.buildIndexedMesh(model, args, modelBuilder, planche.getTransform().cpy().inv());
			break;
		default:
			throw new IllegalArgumentException("Unexpected value: " + modelType);
		}
	}

	private void createSimpleFacade(Planche planche, ModelBuilder modelBuilder) {
		Material frameMaterial = null;
		PbrMaterial plancheVitreMaterial=planche.getVitreMaterial();
		PbrMaterial plancheMaterial=planche.getMaterial();
		if(plancheVitreMaterial!= null)
		{
			plancheVitreMaterial.prepare();
			plancheMaterial.toGdxMaterial();
		}
		if(plancheMaterial != null)
		{
			if(!plancheMaterial.isReady())
				plancheMaterial.prepare();
			plancheMaterial.toGdxMaterial();
		}
		frameMaterial = plancheMaterial;
		frameMaterial.id = planche.getPiece2D().getName() + "frame";
		
		PolygonBuilder.createPolygoneNode(modelBuilder, "planche" , planche.getLocalVertices(), planche.getExtrusionVertices(), frameMaterial, planche.getTransform().cpy().inv(),planche.getThickness()/2, planche.getPiece2D().getName());
		
		if(planche.getExtrusionVertices().size() > 0) {
			Material glassMaterial = plancheVitreMaterial;
			glassMaterial.id = planche.getPiece2D().getName() + "extrusion";

			ArrayList<Vector2> glassPartVertices = new ArrayList<Vector2>();
			int size = planche.getExtrusionVertices().size();
			for(int i = 0; i < size; i++ ) {
				glassPartVertices.add(planche.getExtrusionVertices().get(size - 1 - i).cpy());
			}
			PolygonBuilder.createPolygoneNode(modelBuilder, "planche" , glassPartVertices, new ArrayList<Vector2>(), glassMaterial,
					planche.getTransform().cpy().inv(), planche.getThickness()/2 - 0.005f , "extrusion" + planche.getPiece2D().getName());
		}
		
	}



	private  void addImplicitArgs(Planche planche, HashMap<String, Object>args) {
		Vector3 halfExtents =  planche.getHalfExtents().cpy();
		halfExtents.mul(planche.getTransform()).sub(new Vector3().mul(planche.getTransform()));
		args.put("length", Math.abs(halfExtents.x));
		args.put("height", Math.abs(halfExtents.y));
		args.put("depth", Math.abs(halfExtents.z));
		args.put("Inherited", planche.getMaterial());
		args.put("Vitre", planche.getVitreMaterial());
		
	}
}
