package gdxapp.animation;

import java.util.HashMap;

import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;

import gdxapp.object3d.Animation;
import gdxapp.object3d.Object3D;

public class Object3DAnimator implements IAnimator<Object3D> {
	
	private Object3D target;

	@Override
	public Animation moveTo(Vector3 destination, float duration) {
		Vector3 currentLocation = new Vector3();
		target.transform.getTranslation(currentLocation);
		Vector3 translation = destination.cpy().sub(currentLocation);
		Vector3 velocity = translation.cpy().scl(1.0f/duration);
		HashMap<String, Object> env = new HashMap<String, Object>();
		env.put("animation_duration", duration);
		env.put("destination", destination);
		env.put("velocity", velocity);
		Animation animation = new Animation(env, null) {
			@Override
			public
			Animation act(float delta) {
				setPlaying(true);
				Vector3 currentLocation = new Vector3();
				target.transform.getTranslation(currentLocation);
				Vector3 destination = (Vector3)this.getContext().get("destination");
				Vector3 velocity = (Vector3)getContext().get("velocity");
				if(destination.cpy().sub(currentLocation).dot(velocity) > 0) {   //not there yet
					Vector3 step = velocity.cpy().scl(delta);
					target.transform.translate(step);
					return this;
				}else {
					 target.transform.translate(destination.cpy().sub(currentLocation));
					 target.getWorldObject().setRealWorldPosition(destination);
					 setPlaying(false);
				}				
				return null;
			}
		};
		return animation;
	}

	@Override
	public Animation turnTo(Quaternion orientation, float duration) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Object3D getTransformable() {
		return target;
	}

	@Override
	public void setTarget(Object3D transformable) {
		this.target = transformable;
	}

	@Override
	public void align(Object3D transformable, Quaternion q) {
		// TODO Auto-generated method stub
		
	}

}
