package gdxapp.animation;

import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;

import gdxapp.object3d.Animation;

public interface IAnimator<T> {


	Animation moveTo(Vector3 destination, float duration);

	Animation turnTo(Quaternion orientation, float duration);

	default  void submitAnimations(Animation... animationArray) {
		AnimationManager.getInstance().submitAnimations(animationArray);
	}

	T getTransformable();

	void setTarget(T transformable);


	void align(T transformable, Quaternion q);

}