package dressing.ui.util;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.RenderingHints;
import java.awt.Transparency;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.HashMap;
import java.util.Map;

import org.imgscalr.Scalr;
import org.imgscalr.Scalr.Method;

public class ImageUtils {

	public  static BufferedImage resize(BufferedImage image, int width, int height) {
	    int type = image.getType() == 0? BufferedImage.TYPE_INT_ARGB : image.getType();
	    BufferedImage resizedImage = new BufferedImage(width, height, type);
	    Graphics2D g = resizedImage.createGraphics();
	    g.setComposite(AlphaComposite.Src);

	    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION,
	    RenderingHints.VALUE_INTERPOLATION_BILINEAR);

	    g.setRenderingHint(RenderingHints.KEY_RENDERING,
	    RenderingHints.VALUE_RENDER_QUALITY);

	    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
	    RenderingHints.VALUE_ANTIALIAS_ON);

	    g.drawImage(image, 0, 0, width, height, null);
	    g.dispose();
	    return resizedImage;
	}
	
	public static BufferedImage blurImage(BufferedImage image) {
	    float ninth = 1.0f/9.0f;
	    float[] blurKernel = {
	        ninth, ninth, ninth,
	        ninth, ninth, ninth,
	        ninth, ninth, ninth
	    };

	    Map map = new HashMap();

	    map.put(RenderingHints.KEY_INTERPOLATION,
	    RenderingHints.VALUE_INTERPOLATION_BILINEAR);

	    map.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
	    map.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

	    RenderingHints hints = new RenderingHints(map);
	    BufferedImageOp op = new ConvolveOp(new Kernel(3, 3, blurKernel), ConvolveOp.EDGE_NO_OP, hints);
	    return op.filter(image, null);
	}
	
	public static BufferedImage resizeTrick(BufferedImage image, int width, int height) {
	    image = blurImage(image);
	    image = resize(image, width, height);
	    return image;
	}
	
	public static BufferedImage resizewithscalar(BufferedImage image, int width, int height)
	{
		BufferedImage scaledImg = Scalr.resize(image, Method.SPEED, width, height, Scalr.OP_ANTIALIAS);
		return scaledImg;
	}
}
