package dressing.ui.project;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.List;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.Vector4;
import dressing.model.ModelProvider;
import dressing.ui.util.SingleImageItemLabelProvider;
import gdxapp.object3d.GeometryObject;
import gdxapp.object3d.WorldObject;
import gdxapp.shaders.PbrMaterial;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class GeometricObjectSettingComposite extends Composite {

	//model attributes"
	private GeometryObject worldObject;
	private PbrMaterial material;
	float thickness;
	float height;
	
	//ui attributes
	private TableComboViewer tcvMaterial;
	private Button btnPreview;
	SingleImageItemLabelProvider labelProvider;
	private Spinner SPepaisseur;
	private Spinner SPhauteure;
	
	//events
	private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

	public GeometricObjectSettingComposite(Composite parent, int style, GeometryObject worldObjectX, List<PbrMaterial> input) {
		super(parent, style);
		this.worldObject = worldObjectX;
		setLayout(new GridLayout(1, false));

		Composite composite = new Composite(this, SWT.NONE);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		composite.setLayout(new GridLayout(1, false));

		CBanner banner = new CBanner(composite, SWT.NONE);
		banner.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, true, 1, 1));
		banner.setRightWidth(300);
		banner.setRightMinimumSize(new Point(300, 300));
		banner.setLocation(0, 0);

		Composite composite_1 = new Composite(banner, SWT.NONE);
		banner.setLeft(composite_1);
		GridLayout gl_composite_1 = new GridLayout(1, true);
		gl_composite_1.marginBottom = 50;
		gl_composite_1.marginTop = 50;
		composite_1.setLayout(gl_composite_1);

		Composite composite_3 = new Composite(composite_1, SWT.NONE);
		composite_3.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		composite_3.setLayout(new GridLayout(2, false));

		labelProvider = SingleImageItemLabelProvider.getInstance();

		Label lblTexture = new Label(composite_3, SWT.NONE);
		lblTexture.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, true, 1, 1));
		lblTexture.setText("Motif");

		tcvMaterial = new TableComboViewer(composite_3, SWT.NONE);
		TableCombo tcMaterial = tcvMaterial.getTableCombo();
		tcMaterial.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		tcvMaterial.setContentProvider(ArrayContentProvider.getInstance());
		tcvMaterial.setLabelProvider(labelProvider);
		tcvMaterial.setInput(input);
		tcvMaterial.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				materialChanged();
			}
		});

		Composite composite_2 = new Composite(banner, SWT.NONE);
		banner.setRight(composite_2);
		composite_2.setLayout(new GridLayout(1, false));
		btnPreview = new Button(composite_2, SWT.NONE);
		btnPreview.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
	
//		if(worldObject != null) {
			Label lblHauteur = new Label(composite_1, SWT.NONE);
			lblHauteur.setText("Hauteur");

			SPhauteure = new Spinner(composite_1, SWT.BORDER);
			SPhauteure.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
			SPhauteure.setMaximum(5000);
			SPhauteure.addModifyListener(new ModifyListener() {
				@Override
				public void modifyText(ModifyEvent e) {
					height = SPhauteure.getSelection() / 1000f;
					pcs.firePropertyChange("material", null, material);
				}
			});

//		}

		Label lblEpaisseur = new Label(composite_1, SWT.NONE);
		lblEpaisseur.setText("Épaisseur");

		SPepaisseur = new Spinner(composite_1, SWT.BORDER);
		SPepaisseur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		SPepaisseur.setMaximum(10000);
		SPepaisseur.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				thickness = SPepaisseur.getSelection() / 1000f;
				pcs.firePropertyChange("material", null, material);
			}
		});

		if(worldObject != null)
			bind();

	}

	public void bind() {
		PbrMaterial selection = null;
		try {
			 selection = ModelProvider.findMaterial(null ,worldObject.getGeometry().getBorder().getMaterial().getName());
		}catch (NullPointerException e) {
			System.err.println("unkown material");
		}
		if(selection != null) {
			tcvMaterial.setSelection(new StructuredSelection(selection));
		}
		Vector3 position = worldObject.getRealWorldPosition().cpy();
		position.scl(1000);
		Vector4 dimension = worldObject.getRealWorldDimension().cpy();
		dimension.scl(1000);
		float y = position.y - dimension.y/2.0f;
		int height = Math.round(y);
		SPhauteure.setSelection(height);
		int thickness = Math.round(dimension.y);
		SPepaisseur.setSelection(thickness);
		layout(true);
		
	}
	
	
    public void apply() {
		if(hasValidInput() && worldObject != null) {
			worldObject.setRealWorldDimension(worldObject.getGeometry().getRealWorldDimension(thickness));
			float y = height + thickness/2;
			worldObject.getRealWorldPosition().y = y;
			worldObject.getGeometry().getBorder().setMaterial(material.cpy());
		}
	}

	protected void materialChanged() {
		material = (PbrMaterial) tcvMaterial.getStructuredSelection().getFirstElement();
		if (material != null) {
			if (btnPreview != null)
				btnPreview.setImage(ModelProvider.getTexture(material.getAlbedoMapPath()).getPreview());
				this.pcs.firePropertyChange("material", null, material);
		}
	}

	public WorldObject getWorldObject() {
		return this.worldObject;
	}

	public void setWorldObject(GeometryObject worldObject) {
		this.worldObject = worldObject;
		bind();
	}
	
	public void setMaterialsList(List<PbrMaterial> materials) {
		if(this.tcvMaterial != null)
			this.tcvMaterial.setInput(materials);
	}

	public PbrMaterial getMaterial() {
		return material;
	}
	
	

	public float getThickness() {
		return thickness;
	}

	public boolean hasValidInput() {
		return material != null && thickness > 0.001f;

	}
	
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		this.pcs.addPropertyChangeListener(listener);
	}

	@Override
	public void dispose() {
		super.dispose();
		Arrays.asList(pcs.getPropertyChangeListeners()).forEach((l) -> pcs.removePropertyChangeListener(l));
	}

	

}
