package dressing.mathutils.simulatedannealing;

import java.util.ArrayList;
import java.util.Random;

public class Solver {

	Config config;
	
	
	
	public Solver(Config config) {
		super();
		this.config = config;
	}


	public Solution solve(Problem problem){
		
		
		double temp = config.initialTemprature;
        //create random intial solution
		Solution currentSolution = new Solution(problem);
		currentSolution.generateSolution();

		System.out.println("Total distance of initial solution: " + currentSolution.calculateFitness());
		System.out.println("Tour: " + currentSolution);

		// We would like to keep track if the best solution
		// Assume best solution is the current solution
		Solution best = currentSolution;

		// Loop until system has cooled
		while (temp > 1) {
			// Create new neighbour tour
			Solution newSolution = new Solution(currentSolution);
			// Get energy of solutions
			double currentDistance   = currentSolution.calculateFitness();
			double neighbourDistance = newSolution.calculateFitness();
			// Decide if we should accept the neighbour
			double rand = new Random().nextDouble();
			if (this.acceptanceProbability(currentDistance, neighbourDistance, temp) > rand) {
				currentSolution = newSolution;
			}
			// Keep track of the best solution found
			if (currentSolution.calculateFitness() < best.calculateFitness()) {
				best = currentSolution;
				System.out.println("new best score: " + best.calculateFitness() );
			}
			// Cool system
			temp *= 1 - config.coolingRate;
		}

//		return best.calculateFitness();
		return best;
	}
	
	
	public static double acceptanceProbability(double currentDistance, double newDistance, double temperature) {
		// If the new solution is better, accept it
		if (newDistance < currentDistance) {
			return 1.0;
		}
		// If the new solution is worse, calculate an acceptance probability
		return Math.exp((currentDistance - newDistance) / temperature);
	}
}
