/*
 * Decompiled with CFR 0.152.
 */
package api.events;

import api.events.CustomEvent;
import api.events.EventHandler;
import api.events.EventType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class EventBus {
    private HashMap<EventType, List<EventHandler>> eventHandlers = new HashMap();
    private static EventBus instance = new EventBus();

    private EventBus() {
    }

    public void register(EventType event, EventHandler handler) {
        List<EventHandler> handlers = this.eventHandlers.get((Object)event);
        if (handlers == null) {
            handlers = new ArrayList<EventHandler>();
            this.eventHandlers.put(event, handlers);
        }
        if (!handlers.contains(handler)) {
            handlers.add(handler);
        }
    }

    public void notify(CustomEvent event) {
        List<EventHandler> handlers = this.eventHandlers.get((Object)event.getType());
        if (handlers != null) {
            for (EventHandler handler : handlers) {
                handler.handle(event);
            }
        }
    }

    public static EventBus getInstance() {
        return instance;
    }

    public void clear() {
        this.eventHandlers.clear();
    }
}

