/*
 * Decompiled with CFR 0.152.
 */
package com.frs.supercad.parametric_model.api.ui;

import com.frs.supercad.parametric_model.api.core.ModelParameter;
import com.frs.supercad.parametric_model.api.core.ParametricModel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class ParametricModelUIFactory {
    public Composite createUI(ParametricModel model, Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        for (ModelParameter param : model.getParameters()) {
            this.createUi(param, container);
        }
        return container;
    }

    private void createUi(ModelParameter param, Composite container) {
        Class<?> type = param.getType();
        if (type == Float.TYPE) {
            this.createFloatParameterUI(param, container);
        } else if (type == String.class) {
            this.createStringParameterUI(param, container);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void createStringParameterUI(ModelParameter param, Composite container) {
    }

    private void createFloatParameterUI(ModelParameter param, Composite container) {
        Label dsiplayLbl = new Label(container, 0);
        dsiplayLbl.setText(param.getDisplayName());
        Spinner spinner = new Spinner(container, 0);
        GridData gridData = new GridData(4, 0x1000000, true, true);
        spinner.setLayoutData((Object)gridData);
        spinner.setMaximum(10000);
        float value = ((Float)param.getValue()).floatValue() * 1000.0f;
        spinner.setSelection(Math.round(value));
        spinner.addModifyListener(e -> param.setValue(Float.valueOf((float)spinner.getSelection() / 1000.0f)));
    }
}

