/*
 * Decompiled with CFR 0.152.
 */
package com.frs.supercad.parametric_model.api.core;

import com.frs.supercad.parametric_model.api.core.ModelParameter;
import com.frs.supercad.parametric_model.api.core.ParametricModel;
import java.util.ArrayList;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.mozilla.javascript.engine.RhinoScriptEngineFactory;

public class ParametricModelCompiler {
    private ScriptEngine scriptEngine;
    private Bindings bindings;

    public ParametricModelCompiler() {
        this.init();
    }

    private void init() {
        this.scriptEngine = new RhinoScriptEngineFactory().getScriptEngine();
    }

    public void compileModel(ParametricModel model) {
        ParametricModel.ModelType modelType = model.getType();
        switch (modelType) {
            case DEEP_POLY: {
                this.compileDeepPoly(model);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)modelType));
            }
        }
    }

    private void compileDeepPoly(ParametricModel model) {
        JSONObject json = model.getSource();
        String verticesSrc = json.get((Object)"vertices").toString();
        model.setParameter("l", Float.valueOf(0.009f));
        model.setParameter("h", Float.valueOf(0.36f));
        model.setParameter("d", Float.valueOf(0.3f));
        this.bindings = this.scriptEngine.createBindings();
        for (ModelParameter param : model.getParameters()) {
            String ref = "$" + param.getRef() + "$";
            String value = String.valueOf(param.getValue());
            this.bindings.put(ref, (Object)value);
            verticesSrc = verticesSrc.replace(ref, value);
        }
        JSONParser parser = new JSONParser();
        try {
            JSONArray verticesJSON = (JSONArray)parser.parse(verticesSrc);
            ArrayList<Float[]> vertices = new ArrayList<Float[]>();
            for (Object position : verticesJSON) {
                Float[] vertex = this.parseFloatArray((JSONArray)position);
                vertices.add(vertex);
            }
            int size = 2 * vertices.size();
            int c = 0;
            float[] vertexData = new float[size];
            for (Float[] vertex : vertices) {
                vertexData[c++] = vertex[0].floatValue();
                vertexData[c++] = vertex[1].floatValue();
            }
            model.setVertices(vertexData);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private Float[] parseFloatArray(JSONArray position) {
        Float[] coords = new Float[position.size()];
        int i = 0;
        while (i < position.size()) {
            String str = (String)position.get(i);
            try {
                Number number = (Number)this.scriptEngine.eval(str, this.bindings);
                coords[i] = Float.valueOf(number.floatValue());
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return coords;
    }
}

