	
package model.piece2dcreator;
import org.junit.Test;
import static org.junit.Assert.*;

import dressing.model.DesignException;
import dressing.model.Materiaux;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.PieceType;
import dressing.model.types.PositionCalculationType;
import dressing.model.types.PositionReferenceType;
import dressing.model.types.SeprationAxe;
import dressing.model.Separator;
import utils.ParametersUtils;
/**
 * 
 * ce classe de testCases tester tout les possibilité du séparateur dans piece2dCreator
 *
 */

public class Piece2dCreatorTestCases extends Checks{

	@Test
	public void test_create_0() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_1() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_2() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_3() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_4() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_5() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_6() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_7() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_8() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_9() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_10() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_11() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_12() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_13() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_14() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_15() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_16() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_17() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_18() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_19() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_20() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_21() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_22() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_23() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_24() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_25() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_26() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_27() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_28() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_29() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_30() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_31() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_32() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_33() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_34() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_35() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_36() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_37() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_38() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_39() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_40() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_41() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_42() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_43() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_44() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_45() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_46() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_47() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_48() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_49() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_50() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_51() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_52() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_53() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_54() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 400;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 100;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_55() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 45;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 200;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_56() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 400;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_57() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 30;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 200;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_58() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 400;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_59() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 45;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_60() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 45;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 100;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_61() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 30;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_62() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 30;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 100;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_63() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 30;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 200;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_64() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 200;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_65() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 400;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_66() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 45;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_67() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 30;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_68() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 400;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_69() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 100;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_70() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 45;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 100;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_71() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 30;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 200;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_72() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 100;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_73() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 400;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 200;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_74() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 30;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 100;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_75() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 45;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_76() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 400;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 100;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_77() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 400;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_78() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 45;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_79() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 400;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 100;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_80() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 100;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_81() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 30;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_82() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 400;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 100;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_83() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 30;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_84() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 45;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 200;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_85() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 45;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 200;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_86() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 200;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_87() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 45;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 200;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_88() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 30;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_89() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 100;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_90() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 45;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 100;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_91() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 400;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 200;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_92() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 45;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 100;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_93() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 400;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 200;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_94() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 400;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 200;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_95() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 30;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_96() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 400;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 200;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_97() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 200;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_98() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 400;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_99() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 45;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 200;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_100() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 30;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_101() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 45;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_102() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 400;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_103() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 30;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 200;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_104() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 400;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 100;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_105() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 45;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_106() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 400;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_107() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 45;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_108() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 45;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_109() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 30;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_110() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 45;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_111() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 200;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_112() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 30;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 100;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_113() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 30;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_114() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 45;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = false;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 100;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_115() {
    	PieceType piecetype = PieceType.SEPRATEUR_TRANSVERSANT;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 30;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 0;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 200;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_116() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 400;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 200;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 0;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_117() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 30;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.ZAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.HAUT;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 100;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}

	@Test
	public void test_create_118() {
    	PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.XAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 100;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 50;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
                         
		assertEquals(material,piece2dCreator.getMaterial());
    
		try {
		piece2dCreator.create();
			checkCaissonDimensionPiece(piece2dCreator);
		checkCanHold(caisson);
		checkPieceTypes(piece2dCreator);
		CheckCaissonSeparator(piece2dCreator);
		CheckPositionsPieceCaisson(piece2dCreator);
		CheckSeparatorDos(piece2dCreator);
		} catch (DesignException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		} catch (GeometricEngineException e) {
			System.err.println(e.getMessage());
			fail(e.getMessage());
		}
	  
	  
	}
}
