// Add event listener to the "ajouter" button
document.getElementById("add-btn").addEventListener("click", function(event) {
    // Prevent default behavior (optional, depending on your needs)
    event.preventDefault();

    // Capture the input values
    const data = {
        center: document.getElementById("input-center").value,
        reference: document.getElementById("input-reference").value,
        designation: document.getElementById("input-designation").value,
        quantity: document.getElementById("input-qty").value,
        price: document.getElementById("input-price").value,
        remise: document.getElementById("input-remise").value
    };

    // Send the data to the API using Fetch API
    fetch("/api/article", { // Replace this with your actual API endpoint
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        body: JSON.stringify(data)
    })
    .then(response => response.json())
    .then(data => {
        console.log("Success:", data);
        // You can handle updating the UI here
    })
    .catch(error => {
        console.error("Error:", error);
    });
});
