package gdxapp.tests;

import java.awt.BorderLayout;
import java.awt.ScrollPane;

import javax.swing.SwingUtilities;

import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl.LwjglCanvas;

public class PlayGround implements Runnable{

	@Override
	public void run() {
		Display display = new Display();
		Shell shell = new Shell(display);
		shell.setSize(720, 480);
		shell.setLayout(new GridLayout(1, false));
		Composite swtAwtComponent = new Composite(shell, SWT.EMBEDDED);
		swtAwtComponent.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		swtAwtComponent.setLayout(new GridLayout(1, false));
		java.awt.Frame frame = SWT_AWT.new_Frame(swtAwtComponent);
		
		SwingUtilities.invokeLater(new Runnable() {
			@Override
			public void run() {
				// TODO Auto-generated method stub
				javax.swing.JPanel panel = new javax.swing.JPanel();
				frame.add(panel);
				//add canvas
				panel.setLayout(new BorderLayout());
				
				LwjglApplicationConfiguration config = new LwjglApplicationConfiguration();
				    config.samples = 8;
				    config.width = 1400;
				    config.height = 1400;
					config.forceExit = false;
					config.useGL30 = false;
					LwjglCanvas	lwjglCanvas = new LwjglCanvas(new GdxPlayground(), config) ;
				lwjglCanvas.getCanvas().setSize(config.width,config.height);
				panel.add(lwjglCanvas.getCanvas(),BorderLayout.CENTER);
			}
		});
		
		shell.open();
		while(!display.isDisposed()) {
			if (!display.readAndDispatch())
		        display.sleep();
		}
		display.dispose();		
	}
	
	public static void main(String... args) {
		Thread thread = new Thread(new PlayGround());
		thread.start();
	}
	
	

	
}
