package gdxapp.tests;

import org.lwjgl.opengl.GL11;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input.Keys;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.utils.DefaultShaderProvider;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;

import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import gdxapp.Commun.ScreenshotFactory;
import gdxapp.object3d.JPullProfile;
import gdxapp.screens.room3d.MouseOnlyCameraController;
import gdxapp.shaders.SceneShader;

public class ElementBuilder implements Screen {
	
	private Camera camera;
	private ModelBatch batch;
	private Environment environment;
	private MouseOnlyCameraController camController;
	private boolean render = false;
	private boolean initialized = false;
	private JPullProfile profile;
	private ShapeRenderer shapeRenderer;
	private ModelInstance instance;
	
	void init(){
	}

	@Override
	public void show() {
		// TODO Auto-generated method stub
		 environment = new Environment();
	     environment.set(new ColorAttribute(ColorAttribute.AmbientLight, 0.4f, 0.4f, 0.4f, 1f));
	     environment.add(new DirectionalLight().set(0.8f, 0.8f, 0.8f, 5, 5, -5f));
	     camera = new PerspectiveCamera(60,10,10);
	     camera.position.set(0,0,10);
	     camera.lookAt(0,0,0);
	     camera.up.set(0,0,1);
	     camera.near = 0.1f;
	     camera.far = 50;
	     camera.update();
	     camController = new MouseOnlyCameraController(camera);
	     Gdx.input.setInputProcessor(camController);
	     Shader sceneShader = new SceneShader();
	     sceneShader.init();
	     batch  = new ModelBatch(new DefaultShaderProvider() {
				@Override
				protected Shader createShader(Renderable renderable) {
					return sceneShader;
				}

				@Override
				public Shader getShader(Renderable renderable) {
					return sceneShader;
				}
			});
	     
	     shapeRenderer = new ShapeRenderer(10000);
		profile = new JPullProfile();
		profile.setMaterial(ModelProvider.getMaterialsByCategory(CATEGORY.KNOBS).get(0));
		profile.createModel();
		instance = new ModelInstance( profile.getModel());
		//instance.transform.scale(0.1f, 0.1f, 0.1f);

	}
	public void inputHandler() {
		if(Gdx.input.isKeyPressed(Keys.S))
			ScreenshotFactory.saveScreen(Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), "article");
	}

	@Override
	public void render(float delta) {
		inputHandler();
		if( ProjectManager.instance.getCurrentScene().requireRefresh) {
			init();
			 ProjectManager.instance.getCurrentScene().requireRefresh = false;
		}	
		Gdx.gl20.glClearColor(1.0f,1.0f,1.0f,1);
		Gdx.gl.glClear(GL20.GL_COLOR_BUFFER_BIT | GL20.GL_DEPTH_BUFFER_BIT |
				(Gdx.graphics.getBufferFormat().coverageSampling ? GL20.GL_COVERAGE_BUFFER_BIT_NV : 0));
        camController.update();
        GL11.glPolygonMode(GL11.GL_FRONT_AND_BACK, GL11.GL_LINE);
        batch.begin(camera);
        batch.render(instance);
        batch.end();
	}

	@Override
	public void resize(int width, int height) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void pause() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void resume() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void hide() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void dispose() {
		// TODO Auto-generated method stub
		batch.dispose();
		instance.model.dispose();
		
	}
	
	class ElementDrwaer{
		
	}

}
