package gdxapp.screens.room3d;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.*;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.utils.DefaultShaderProvider;
import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder.VertexInfo;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.frs.supercad.parametric_model.api.core.ParametricModelCompiler;
import com.frs.supercad.parametric_model.api.core.ParametricModelLoader;

import dressing.config.WorkspaceConfiguration;
import dressing.config.ui.ActionListManager;
import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.events.EventHandler;
import dressing.io.IOUtilities;
import dressing.mathutils.EarClipper;
import dressing.mathutils.Edge;
import dressing.mathutils.MathUtilities;
import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import dressing.ui.ChangeCommandController;
import dressing.ui.ProgressBarMonitor;
import dressing.ui.caisson.ElementFacadeConfigWindow;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import dressing.ui.parts.GdxPart;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.GeometricObjectConfigWindow;
import dressing.ui.util.MesureWidow;
import dressing.ui.util.ModelInstanceEditorWindow;
import dressing.ui.util.PlinthCreationWindow;
import dressing.ui.util.WallSettingWindow;
import gdxapp.ModelViewer;
import gdxapp.Commun.GroupSelection;
import gdxapp.Commun.ScreenController;
import gdxapp.Commun.ScreenshotFactory;
import gdxapp.animation.CameraAnimator;
import gdxapp.assets.AssetsTextures;
import gdxapp.assets.ModelExporter;
import gdxapp.fabs3d.WoodCovering;
import gdxapp.object3d.GeometryObject;
import gdxapp.object3d.GeometryObject2D;
import gdxapp.object3d.GolaProfile;
import gdxapp.object3d.JPullProfile;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.ModeledObject;
import gdxapp.object3d.Object2D;
import gdxapp.object3d.Object3D;
import gdxapp.object3d.Object3DFactory;
import gdxapp.object3d.ObjectModel;
import gdxapp.object3d.Plinth;
import gdxapp.object3d.PlinthObject;
import gdxapp.object3d.PolygonBuilder;
import gdxapp.object3d.Wall;
import gdxapp.object3d.WallSide;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.quotation.Object3DQuotationManager;
import gdxapp.scenes.SceneEvent;
import gdxapp.screens.ObjectEditor.DrawableInputProcessor;
import gdxapp.screens.ObjectEditor.Object3DRightClickMenu;
import gdxapp.screens.ObjectEditor.ObjectSelector;
import gdxapp.screens.ObjectEditor.ScreenUtilities;
import gdxapp.screens.wall.Wall2D;
import gdxapp.shaders.SceneShader;
import gdxapp.ui.ActionItem;
import gdxapp.ui.ObjectMenuList;
import geometry.Box;
import geometry.Triangle3D;
import supercad.graphics.InstancedSceneExporter;
import supercad.graphics.SceneExporter;
import supercad.graphics.quotations.OrthogonalQuotationManager;

public class Room3DController implements EventHandler, Disposable, ScreenController<Object3D> {

	private PerspectiveCamera camera;
	private final ArrayList<Object3D> actors = new ArrayList<Object3D>();
	private final ArrayList<Wall> walls = new ArrayList<Wall>();
	private final ArrayList<Object3D> hiddenActors = new ArrayList<Object3D>();
	private MouseOnlyCameraController cameraController;
	public ModelBatch sceneBatch;
	public SceneShader sceneShader;
	private Vector3 kitchenCenter;
	private Stage uiStage;
	private ObjectSelector objectSelector;
	private Object3DQuotationManager quotationManager;
	private InputMultiplexer inputMultiplexer;
	private Object3D selection;
	private Material selectionMtl;
	private DrawableInputProcessor activeProcessor;
	private static Room3DController instance;
	private Vector3[] kitchenBounds = new Vector3[2];
	private boolean handleEvent;
	private ModelInstance testObject;

	public Room3DController() {
		init();
		subscribeToEvents();
	}

	private void subscribeToEvents() {
		subscribe(SceneEvent.CLEAR_KEYBOARD_FOCUS.name(), SceneEvent.HIDE_OBJECT.name(), SceneEvent.UNHIDE_ALL.name(),
				SceneEvent.ISOLATED_VIEW.name(), SceneEvent.QUOTS_REQUEST.name(), SceneEvent.HIDE_QUOTS.name(),
				SceneEvent.EDIT_OBJECT.name(), SceneEvent.MODIFY_OBJECT.name(), SceneEvent.OBJECT_CHANGED.name(),
				SceneEvent.DELETE_OBJECT.name());
	}

	public static Room3DController getInstance() {
		synchronized (Room3DController.class) {
			if (instance == null) {
				instance = new Room3DController();
			}
			return instance;
		}
	}
	
	private void init() {
		setUpCamera();
		setUpShaders();
		setUpUiLayer();
		setUpInput();
		quotationManager = Object3DQuotationManager.getManager();
	}

	public void test() {
		String path = "C:\\ProgramData\\supercad\\Data\\kitchen\\libraries\\parametric models\\model0.json";
		ParametricModelLoader loader = new ParametricModelLoader();
		var model = loader.loadModel(path);
		ParametricModelCompiler compiler = new ParametricModelCompiler();
		compiler.compileModel(model);
		ArrayList<Vector2> vertices = new ArrayList<Vector2>();
		Vector2 tmp = new Vector2();
		float[] vertexData = model.getVertices();
		for(int i = 0; i <model.getVertices().length; i++) {
			int index = (i)%2;
			if(index == 0) {
				tmp.x = vertexData[i];
			}else {
				tmp.y = vertexData[i];
				vertices.add(tmp.cpy());
			}
		}
		float l = (float) model.getParameter("l");
		float h = (float) model.getParameter("h");
		float depth = (float) model.getParameter("d");
		var triangles = EarClipper.triangulate(vertices);
		ArrayList<Triangle3D> faceTriangles = new ArrayList<Triangle3D>();
		ArrayList<Triangle3D> backTriangles = new ArrayList<Triangle3D>();
		for(var tr: triangles) {
			faceTriangles.add(new Triangle3D(new Vector3(tr.getV0(), depth), new Vector3(tr.getV1(), depth), new Vector3(tr.getV2(),depth)));
			backTriangles.add(new Triangle3D(new Vector3(tr.getV0(), -depth), new Vector3(tr.getV1(), -depth), new Vector3(tr.getV2(),-depth)));

		}
		triangles.toString();
		ModelBuilder modelBuilder = new ModelBuilder();
		modelBuilder.begin();
		int attrs = VertexAttributes.Usage.Position | VertexAttributes.Usage.Normal | VertexAttributes.Usage.TextureCoordinates;
		var partBuilder = modelBuilder.part("nigga", GL20.GL_TRIANGLES, attrs , selectionMtl);
		//face triangles
		for(int i = 0 ; i < triangles.size(); i++) {
			var faceVertices = faceTriangles.get(i).getVertices();
			Vector2[] uvs = new Vector2[3];
			int c = 0;
			for(var vertex: faceVertices) {
				float u = (vertex.x + l)/ (2 *l);
				float v = (vertex.y + h)/ (2 *h);
			}
			Vector3 normal = faceTriangles.get(i).getNormal();
			var backVertices = backTriangles.get(i).getVertices();
			
			VertexInfo i0 = new VertexInfo().setPos(faceVertices[0]).setNor(normal).setUV(uvs[0]);
			VertexInfo i1 = new VertexInfo().setPos(faceVertices[1]).setNor(normal).setUV(uvs[1]);
			VertexInfo i2 = new VertexInfo().setPos(faceVertices[2]).setNor(normal).setUV(uvs[2]);

			VertexInfo i0b = new VertexInfo().setPos(backVertices[0]).setNor(normal.cpy().scl(-1)).setUV(uvs[0]);
			VertexInfo i1b = new VertexInfo().setPos(backVertices[1]).setNor(normal.cpy().scl(-1)).setUV(uvs[1]);
			VertexInfo i2b = new VertexInfo().setPos(backVertices[2]).setNor(normal.cpy().scl(-1)).setUV(uvs[2]);
			
			partBuilder.triangle(i0, i1, i2);
			partBuilder.triangle(i0b, i1b , i2b);
		}
		//side triangle
		List<Edge> externalEdges = MathUtilities.findExternalEdges(triangles);
		for(Edge edgeX: externalEdges) {
			partBuilder.triangle(new Vector3(edgeX.getV0(), depth), new Vector3(edgeX.getV1(), depth), new Vector3(edgeX.getV1(), -depth));
			partBuilder.triangle(new Vector3(edgeX.getV0(), depth), new Vector3(edgeX.getV1(), -depth), new Vector3(edgeX.getV1(), depth));
			partBuilder.triangle(new Vector3(edgeX.getV1(), -depth), new Vector3(edgeX.getV0(), -depth), new Vector3(edgeX.getV0(), depth));
			partBuilder.triangle(new Vector3(edgeX.getV1(), -depth), new Vector3(edgeX.getV0(), depth), new Vector3(edgeX.getV0(), -depth));


		}
		Model modelX = modelBuilder.end();
		testObject = new ModelInstance(modelX);
		
	}

	

	private void setUpUiLayer() {
		uiStage = new Stage(new ScreenViewport());

	}

	private void setUpInput() {
		ArrayList<Object3D> selectionActors = getSelectionActors();	
		objectSelector = new ObjectSelector(cameraController.getCurrentCamera(), selectionActors);
		inputMultiplexer = new InputMultiplexer();
		inputMultiplexer.addProcessor(uiStage);
		inputMultiplexer.addProcessor(objectSelector);
		inputMultiplexer.addProcessor(cameraController);
		Gdx.input.setInputProcessor(inputMultiplexer);
	}

	private ArrayList<Object3D> getSelectionActors() {
		ArrayList<Object3D> selectionActors=new ArrayList<Object3D>();
		selectionActors.addAll(actors);
		for(Wall wall:walls) {
			List<Object3D> fragments = Arrays.asList(((Wall) wall).get3DObjects());
			for (Object3D fragment : fragments) {
				if (!selectionActors.contains(fragment))
					selectionActors.add(fragment);
			}
		}
		return selectionActors;
	}

	private void setUpShaders() {
		sceneShader = new SceneShader();
		sceneShader.init();
		sceneBatch = new ModelBatch(new DefaultShaderProvider() {
			@Override
			protected Shader createShader(Renderable renderable) {
				return sceneShader;
			}

			@Override
			public Shader getShader(Renderable renderable) {
				return sceneShader;
			}
		});

		this.selectionMtl = new Material(ColorAttribute.createDiffuse(Color.RED));
	}

	private void setUpCamera() {
		camera = new PerspectiveCamera(67, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
		camera.position.set(5, 1.7f, 5);
		camera.lookAt(5.0f, 1.7f, 0);
		camera.near = 0.1f;
		camera.far = 25;
		camera.up.set(0, 1, 0);
		camera.update();
		cameraController = new MouseOnlyCameraController(camera);
		CameraAnimator.getInstance().setTarget(camera);
	}

	public void initializeActors() {
		unhideAll();
		hiddenActors.clear();
		removeDeletedOrModifiedObjects();
		ArrayList<WorldObject> sceneObjects = fetchNewObject();
		try {
			ContainmentManager.getManager().init();
			var additions = ContainmentManager.getManager().execute();
			sceneObjects.addAll(additions);
		} catch (IOException e1) {
			e1.printStackTrace();
		}
		
		
		for (WorldObject object : sceneObjects) {
			try {
				if (object instanceof Wall) {
					Wall wall = (Wall) object;
					if(!walls.contains(wall))
						walls.add(wall);
					if(wall.isRequireRefrech()) {
						wall.buildFragments();
						wall.setRequireRefrech(false);
					}
				} else if (object.isRequireRefrech() && object instanceof PlinthObject) {
					((PlinthObject) object).prepareModel();
				} else if (object.isRequireRefrech() && object instanceof WoodCovering) {
					WoodCovering habillage = (WoodCovering) object;
					habillage.prepareModel();
				} else if (object.getType() == ObjectType.POLY) {
					if (object.getModel() == null || object.isRequireRefrech()) {
						Model model = PolygonBuilder.createModel(((GeometryObject) object).getGeometry(),
								object.getRealWorldPosition().y - object.getRealWorldDimension().y / 2,
								object.getRealWorldPosition().y + object.getRealWorldDimension().y / 2);
						object.setModel(new ObjectModel(model, null));
					}
				}

				object.setRequireRefrech(false);

				if (object instanceof KitchenElement) {
					Object3D obj = Object3DFactory.create3DObject((KitchenElement) object);
					actors.add(obj);
				} else {
					if (object != null && object.getModel() != null) {
						Object3D object3d = new Object3D(object);
						actors.add(object3d);
					}
				}

			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		for (Object3D objectX : actors) {
			objectX.updatePosition();
		}
		ArrayList<Object3D> selectionActors = getSelectionActors();
		objectSelector.setObjects(selectionActors);
		calculateSceneBounds();
		cameraController.setOrbitCenter(kitchenCenter);
		cameraController.setSceneBounds(kitchenBounds);
	}

	private void removeDeletedOrModifiedObjects() {
		ArrayList<Object3D> objectsToRemove = new ArrayList<Object3D>();
		for (Object3D object : actors) {
			if (!ProjectManager.getManager().getCurrentScene().getSceneObjects().contains(object.getWorldObject())
					|| (object.getWorldObject().isRequireRefrech())) {
				// exclude wall sides whose parent wall is not changed
				if (object.getWorldObject() instanceof WallSide) {
					Wall wall = ((WallSide) object.getWorldObject()).getWall();
					if (wall.isRequireRefrech()
							|| !ProjectManager.getManager().getCurrentScene().getSceneObjects().contains(wall))
						objectsToRemove.add(object);
				} else {
					objectsToRemove.add(object);
				}
			}
		}
		
		actors.removeAll(objectsToRemove);
		ArrayList<Wall> removedWall = new ArrayList<Wall>();
		for(var wall: walls) {
			if (!ProjectManager.getManager().getCurrentScene().getSceneObjects().contains(wall)
					|| (wall.isRequireRefrech())) {
				// exclude wall sides whose parent wall is not changed
				removedWall.add(wall);
			}
		}
		
		walls.removeAll(removedWall);
		for(var wall: removedWall) {
			try{
				Arrays.asList(wall.get3DObjects()).stream().forEach(wallObject -> wallObject.model.dispose());
			}catch (Exception e) {
				e.printStackTrace();
				continue;
			}
		}		
		for (Object3D disposedObject : objectsToRemove) {
			if (disposedObject.getWorldObject().getType() != ObjectType.MODELED) {
				disposedObject.model.dispose();
			}
			try {
				disposedObject.cleanUp();
			} catch (Exception e) {
				e.printStackTrace();
				continue;
			}
		}
		objectsToRemove.clear();
	}

	private ArrayList<WorldObject> fetchNewObject() {
		ArrayList<WorldObject> newObjects = new ArrayList<WorldObject>();
		for (WorldObject worldObject : ProjectManager.getManager().getCurrentScene().getSceneObjects()) {
			boolean skip = false;
			for (Object3D object3D : actors) {
				if (worldObject == object3D.getWorldObject()) {
					skip = true;
					break;
				}
			}
			if (!skip)
				newObjects.add(worldObject);
		}
		return newObjects;
	}

	public Vector3[] calculateSceneBounds() {
		kitchenBounds[0] = new Vector3(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
		kitchenBounds[1] = new Vector3(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
		ArrayList<Object3D> actorsToDelete = new ArrayList<Object3D>();
		ArrayList<Object3D> objs = new ArrayList<Object3D>();
		objs.addAll(actors);
		for(Wall wall: walls) {
			objs.addAll(Arrays.asList(wall.get3DObjects()));
		}
		for (Object3D object : objs) {
			Vector3[] bounds = object.getBounds();
			if (Float.isNaN(bounds[0].x)) {
				actorsToDelete.add(object);
				ProjectManager.getManager().getCurrentScene().removeWorldObject(object.getWorldObject());
				continue;
			}
			kitchenBounds[0].set(Math.min(kitchenBounds[0].x, bounds[0].x), Math.min(kitchenBounds[0].y, bounds[0].y), Math.min(kitchenBounds[0].z, bounds[0].z));
			kitchenBounds[1].set(Math.max(kitchenBounds[1].x, bounds[1].x), Math.max(kitchenBounds[1].y, bounds[1].y), Math.max(kitchenBounds[1].z, bounds[1].z));
		}
		this.actors.removeAll(actorsToDelete);
		kitchenCenter = kitchenBounds[0].cpy().add(kitchenBounds[1]).scl(0.5f);
		return kitchenBounds;
	}

	public void refresh() {
		Gdx.input.setInputProcessor(inputMultiplexer);
		initializeActors();
		subscribe(SceneEvent.OBJECT_SELECTED.name(), SceneEvent.DISPLAY_ACTIONS_MENU.name(), SceneEvent.REFRESH_OBJECT.name());
		ProjectManager.instance.getCurrentScene().requireRefresh = false;
		//test();
	}

	
	
	public String export3DElements(boolean asFolder) {
		int c = 0;
		ArrayList<Object3D> objects = new ArrayList<Object3D>();
		for(var object: actors) {
			objects.add(object);
			for(var addon: object.getAddons()) {
				Object3D addonX = new Object3D(addon.model);
				addonX.transform.set(object.transform.cpy().mul(addon.transform));
				objects.add(addonX);
			}
		}
		
		for(Wall wall: walls) {
			objects.addAll(Arrays.asList(wall.get3DObjects()));
		}
		String path;
		if(asFolder) {
			String dir = ProjectManager.getManager().getCurrentProjectDirectory();
			File root = new File(dir + File.separator + "3d scene");
			if (root.exists()) {
				IOUtilities.deleteFolder(root);
			}
			root.mkdirs();
			final int size = objects.size();
			Display.getDefault().syncExec(new Runnable() {
				@Override
				public void run() {
					ProgressBarMonitor.setTasks(size);
				}
			});
			ModelExporter modelExporter = new ModelExporter();
			modelExporter.clearRessources();
			for (int i = 0; i < size; i++) {
				try {
					Model model = objects.get(i).model;
					Object3D object3D = (Object3D) objects.get(i);
					Node node = object3D.nodes.get(0);
					Matrix4 transform = object3D.transform.cpy().mul(node.globalTransform);
					modelExporter.setTransform(transform);
					UUID id = null;
					if(object3D.getWorldObject() != null) {
						id = object3D.getWorldObject().getUuid();
					}
					if (id != null && object3D.getWorldObject().getType() == ObjectType.MODELED) {
						modelExporter.exportModel(root.getAbsolutePath(), "object" + ++c, id);

					} else {
						modelExporter.exportModelInstance(model, root.getAbsolutePath(), "object" + ++c, "texture");

					}

				} catch (Exception e) {
					System.err.println("error exporting model!!");
					continue;
				}
			}
			path = root.getAbsolutePath();
		}else {
			InstancedSceneExporter sceneExporter = new InstancedSceneExporter();
			path = sceneExporter.exportScene(objects, ProjectManager.getManager().getCurrentProject().getProjectDirectory() + File.separator + "3DScene");
		}
		return path;
	}

	public void enhancedRender() {
		String sceneFolder = export3DElements(false);
		String cmd = WorkspaceConfiguration.MONKEY_ENGINE;
		ProcessBuilder pb = new ProcessBuilder(cmd, sceneFolder);
		pb.directory(new File(WorkspaceConfiguration.MONKEY_ENGINE).getParentFile());
		pb.inheritIO();
		pb.environment();
		System.err.println("executing command:" + cmd);
		try {
			pb.start();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public void exportScene() {
		export3DElements(true);
		Display.getDefault().asyncExec(new Runnable() {
			@Override
			public void run() {
				Shell shell = new Shell(Display.getCurrent());
				FileDialog fileDialog = new FileDialog(shell, SWT.MULTI);
				fileDialog.setText("select folder");

				String path = fileDialog.open();
				if (path != null) {
					SceneExporter sceneExporter = new SceneExporter();
					String sceneFolder = ProjectManager.getManager().getCurrentProjectDirectory() + File.separator
							+ "3d scene";
					sceneExporter.exportScene(sceneFolder, path);
				}
			}
		});
	}

	public String exportSceneForTechnicalReport() {
		String dir = ProjectManager.getManager().getCurrentProjectDirectory();
		File root = new File(dir + File.separator + "3d plumbing scene");
		if (root.exists()) {
			IOUtilities.deleteFolder(root);
		}
		root.mkdirs();

		int c = 0;
		var objs = new ArrayList<Object3D>();
		objs.addAll(actors);
		for(var wall: walls)
			objs.addAll(Arrays.asList(wall.get3DObjects()));
		final int size = objs.size();
		Display.getDefault().syncExec(new Runnable() {
			@Override
			public void run() {
				ProgressBarMonitor.setTasks(size);
			}
		});
		ModelExporter modelExporter = new ModelExporter();
		modelExporter.clearRessources();
		for (int i = 0; i < size; i++) {
			try {
				Model model = objs.get(i).model;
				Object3D object3D = (Object3D) objs.get(i);
				Node node = object3D.nodes.get(0);
				Matrix4 transform = object3D.transform.cpy().mul(node.globalTransform);
				modelExporter.setTransform(transform);
				UUID id = null;
				if(object3D.getWorldObject().getUuid() != null);
					id = object3D.getWorldObject().getUuid();
				if (id != null && object3D.getWorldObject().getType() == ObjectType.MODELED) {
					modelExporter.exportModel(root.getAbsolutePath(), "object" + ++c, id);
				} else {
					modelExporter.exportModelInstance(model, root.getAbsolutePath(), "object" + ++c, "texture");
				}
			} catch (Exception e) {
				System.err.println("error exporting model!!");
				continue;
			}
		}

		modelExporter.clearRessources();
		modelExporter = null;
		return root.getAbsolutePath();
	}

	@Override
	public void dispose() {
		sceneBatch.dispose();
		actors.clear();
	}

	public MouseOnlyCameraController getCameraController() {
		return cameraController;
	}

	public void renderUI() {
		uiStage.act();
		uiStage.draw();
		//quotationManager.filter(cameraController.getCurrentCamera(), 50);
		quotationManager.draw(uiStage.getBatch());
	}

	public ArrayList<Object3D> getActors() {
		return actors;
	}

	public void setActors(ArrayList<Object3D> actors) {
		this.actors.clear();
		this.actors.addAll(actors);
	}

	@Override
	public void handle(Event event) {
		if(!handleEvent)
			return;
		SceneEvent eventType = SceneEvent.valueOf(event.getTopic());
		switch (eventType) {
		case OBJECT_SELECTED:
			makeSelection(event.getData());
			break;
		case DISPLAY_ACTIONS_MENU:
			displayRightClickMenu(event);
			break;
		case CLEAR_KEYBOARD_FOCUS:
			uiStage.setKeyboardFocus(null);
			break;
		case UNHIDE_ALL:
			unhideAll();
			break;
		case HIDE_OBJECT:
			hide(event.getData());
			break;
		case OBJECT_DROP:
			Gdx.app.postRunnable(new Runnable() {
				@Override
				public void run() {
					objectDropped((Map) event.getData());
				}
			});
			break;
		case QUOTS_REQUEST:
			requsetQuotations(true);
			break;
		case HIDE_QUOTS:
			requsetQuotations(false);
			break;
		case REFRESH_OBJECT:
			reloadActor((WorldObject[])event.getData());
			break;
		case OBJECT_CHANGED:
			WorldObject object = (WorldObject) event.getData();
			reloadActor(object);
			break;
		case DELETE_OBJECT:
			removeActor(event.getData());
		}
	}

	private void requsetQuotations(boolean display) {
		ArrayList<Object3D> quotationsSource = new ArrayList<Object3D>();
		if (display) {
			for (Object3D object : actors) {
				if (object.getWorldObject() instanceof KitchenElement) {
					if (!object.getWorldObject().isHidden())
						quotationsSource.add(object);
				}
			}
		}
		sceneShader.setQuotsMode(display);
		HashMap<String, Object> args = new HashMap<String, Object>();
		args.put("sources", quotationsSource);
		args.put("camera", cameraController.getCurrentCamera());
		EventDriver.getDriver().deliverEvent(SceneEvent.GENERATE_QUOTS, args);
	}

	private void objectDropped(Map dropData) {
		try {
			WorldObject object = (WorldObject) dropData.get("object");
			Vector2 location = (Vector2) dropData.get("location");
			Vector3 position = ScreenUtilities.getRealWorldPoint((int) location.x,
					Gdx.graphics.getHeight() - (int) location.y, cameraController.getCurrentCamera());
			object.setRealWorldPosition(position);
			ProjectManager.getManager().getCurrentScene().addActor(object, true);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void invokeModelViewer(Object data) {
		if (data instanceof KitchenElement) {
			KitchenElement element = (KitchenElement) data;
			Vector3 dimensions = new Vector3(element.getRealWorldDimension().x, element.getRealWorldDimension().y,
					element.getRealWorldDimension().z);

			try {
				ModelViewer viewer = new ModelViewer(1080, 1.0f);
				viewer.render((KitchenElement) data, dimensions.cpy().scl(1.2f, Math.min(1.2f, 2 / dimensions.y), 2));
				viewer.render((KitchenElement) data, dimensions.cpy().scl(1.2f, Math.min(1.2f, 2 / dimensions.y), -2));
				viewer.dispose();
			} catch (Exception e) {
				e.printStackTrace();
			}

		}
	}



	public void draw() {
		if (activeProcessor != null) {
			activeProcessor.draw(uiStage.getBatch());
		}
	}

	private void displayRightClickMenu(Event event) {
		HashMap<String, Object> info = (HashMap<String, Object>) event.getData();
		Vector3 location = ActionListManager.getLocationFromDetails(info);
		List<ActionItem> actions = (List<ActionItem>) info.get("actions");
		ObjectMenuList menu = ObjectMenuList.getInstance(actions);
		menu.setPosition(location.x, location.y - menu.getHeight());
		uiStage.addActor(menu);
	}

	private void makeSelection(Object selection) {
		if (selection != null && selection instanceof Object3D) {
			this.selection = (Object3D) selection;
		}

	}

	public Object3D getSelection() {
		return selection;
	}

	public void setSelection(Object3D selection) {
		this.selection = selection;
	}

	public Material getSelectionMtl() {
		return selectionMtl;
	}

	public void setSelectionMtl(Material selectionMtl) {
		this.selectionMtl = selectionMtl;
	}

	public Stage getUiStage() {
		return uiStage;
	}

	public void setUiStage(Stage uiStage) {
		this.uiStage = uiStage;
	}



	public void hide(Object obj) {

		if (obj != null) {
			if (obj instanceof Wall) {
				Object wallSide = GroupSelection.getInstance().getFirstElement();
				if (wallSide != null && wallSide instanceof WallSide) {
					obj = wallSide;
				}
			}
			if (obj instanceof WorldObject) {
				Object3D obj3D = getObject((WorldObject) obj);
				if (obj3D != null)
					hide(obj3D);
			}

		}
	}

	public void hide(Object3D object) {
		if (object == null) return;
		if (actors.contains(object))
		{
			actors.remove(object);
		}
		
		for(Wall wall:walls) {
			for(var frag :wall.get3DObjects()) {
				if(frag.equals(object)) {
					WorldObject wo = frag.getWorldObject();
					if (wo != null) {
						wo.setHidden(true);
					}
					break;
				}
			}
		}
		
		if (!hiddenActors.contains(object))
			hiddenActors.add(object);
		
	}

	public void unhideAll() {
		actors.addAll(hiddenActors);
		hiddenActors.clear();
		for(Wall wall:walls) {
			for(var frag :wall.get3DObjects()) {
				frag.getWorldObject().setHidden(false);
			}
		}
	}

	// keep in scene only the objects in touch with the supplied object
	public void isolateObject(Object3D object) {
		ArrayList<Object3D> toHide = new ArrayList<Object3D>();
		for (Object3D objectX : actors) {
			if (objectX == object)
				continue;
			if (!objectX.intersects(object)) {
				toHide.add(objectX);
			}
		}
		for (Object3D objectX : toHide) {
			hide(objectX);
		}
	}

	// take screenshots of walls
	public List<String> takeWallViews() {
		System.out.println("taking wall screenshots");
		ModelViewer modelViewer;
		new ArrayList<Pixmap>();
		ArrayList<Object3D> walls = new ArrayList<Object3D>();

		for (Wall wall : this.walls) {
			walls.addAll(Arrays.asList( wall.get3DObjects()));
		}

		ArrayList<String> wallViewsCapture = new ArrayList<String>();

		OrthogonalQuotationManager quotationManager = new OrthogonalQuotationManager();

		for (var wall : walls) {
			this.cameraController.setToProjectionAgainst(wall, true);
			modelViewer = new ModelViewer(720, this.cameraController.getOrthoCamera().viewportWidth
					/ this.cameraController.getOrthoCamera().viewportHeight);
			ArrayList<Object3D> renderable = new ArrayList<Object3D>();
			actors.forEach((actor) -> {
				if (!(actor.getWorldObject() instanceof WallSide || actor.getWorldObject() instanceof GeometryObject))
					renderable.add(actor);
			});
			if (!renderable.isEmpty()) {
				renderable.add(wall);
				Pixmap pixmap = modelViewer.render(renderable, this.cameraController.getCurrentCamera());
				String path = ProjectManager.getManager().getCurrentProject().getProjectDirectory() + File.separator
						+ "reporting" + File.separator + "vue" + walls.indexOf(wall) + ".png";
				File file = new File(path);
				file.getParentFile().mkdirs();
				try {
					file.createNewFile();
					ScreenshotFactory.savePixmapAsPng(pixmap, path);
				} catch (IOException e) {
					e.printStackTrace();
				}

				quotationManager.setSources(renderable);
				quotationManager.setCamera(this.cameraController.getOrthoCamera());
				quotationManager.setBuffer(modelViewer.getFrameBuffer());
				String folder = ProjectManager.getManager().getCurrentProjectDirectory() + File.separator + "reporting";
				quotationManager.setImageURL(path.replace(folder, "http://localhost:8080"));
				quotationManager.generateQuotations();
				String svg = quotationManager.exportSVG();
				wallViewsCapture.add(svg);
				modelViewer.dispose();
			}

			unhideAll();
			cameraController.setCurrentCamera(camera);
		}
		return wallViewsCapture;

	}


	@Override
	public void reloadActors() {
		Gdx.app.postRunnable(new Runnable() {
			@Override
			public void run() {
				initializeActors();
			}
		});
	}

	@Override
	public Stage getUIStage() {
		return uiStage;
	}

	@Override
	public float[] getScales() {
		return null;
	}

	@Override
	public ChangeCommandController getChangeCommandController() {
		return null;
	}

	@Override
	public void clear() {
	}

	@Override
	public void reloadActor(WorldObject... objects) {
		for(WorldObject objectX: objects) {
			if(objectX instanceof Wall) {
				Wall wall = (Wall) objectX;
			}else {
				Object3D obj3D = getObject(objectX);
				if(obj3D != null) {
					actors.remove(obj3D);
					var worldObject = obj3D.getWorldObject();
					Gdx.app.postRunnable(() -> {
						Object3D newObject = null;
						if(worldObject instanceof KitchenElement) {
							newObject = Object3DFactory.create3DObject((KitchenElement) worldObject);
						}else if(worldObject instanceof PlinthObject) {
								PlinthObject plinth = (PlinthObject) worldObject;
								plinth.prepareModel();
								newObject = new Object3D(plinth);
						}
						else if(worldObject instanceof GeometryObject) {
							GeometryObject geometryObj = (GeometryObject) worldObject;
							Model model = PolygonBuilder.createModel(geometryObj.getGeometry(),
									worldObject.getRealWorldPosition().y - geometryObj.getRealWorldDimension().y / 2,
									worldObject.getRealWorldPosition().y + geometryObj.getRealWorldDimension().y / 2);
							geometryObj.setModel(new ObjectModel(model, null));
							newObject = new Object3D(geometryObj);
						}else if(worldObject instanceof ModeledObject) {
							newObject = new Object3D(worldObject);
						}
						newObject.updatePosition();
						actors.add(newObject);
						objectSelector.setObjects(getSelectionActors());
						selection = newObject;
					});
					obj3D = null;
				}
			}
		}
		
	}

	@Override
	public void rectifyPosition(Object3D object) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateWorldObject(Object3D object2d) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void updateObject(WorldObject object) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public Object3D getObject(WorldObject worldObject) {
		if(worldObject instanceof WallSide wallSide) {
			for(Wall wall:walls) {
				for(Object3D Object3D:wall.get3DObjects()) {
					if(Object3D.getWorldObject() == wallSide) {
						return Object3D;
					}
				}
			}
		}

		Object3D object3D= actors.stream().filter(actor -> actor.getWorldObject()==worldObject)
				.findFirst().orElse(null);
		
		return object3D;
	}

	@Override
	public void dropActor(Object actor, float x, float y) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void addActor(Object actor) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void removeActor(Object actor) {
		if(actor instanceof WorldObject) {
			var object = getObject((WorldObject) actor);
			this.actors.remove(object);
			if(actor instanceof Wall) {
				this.walls.remove(actor);
				
			}
		}
	}

	public boolean isHandleEvent() {
		return handleEvent;
	}

	public void setHandleEvent(boolean handleEvent) {
		this.handleEvent = handleEvent;
	}

	public Vector3[] getKitchenBounds() {
		return kitchenBounds;
	}

	public ModelInstance getTestObject() {
		return testObject;
	}
	
	
	


	
}
