package dressing.ui.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

import com.badlogic.gdx.math.Vector3;

import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.ui.util.ColorComposite;
import gdxapp.scenes.SceneEvent;
import gdxapp.scenes.ScenePreferences;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.layout.GridData;

public class ScenePlinthSettingComposite extends Composite {

	
	private ScenePreferences preferences;
	
	private Vector3 color;
	private float height;
	private float thickness;

	private ColorComposite colorComposite;

	private Spinner spnThickness;
	private Label lblCouleur;
	private Label lblHauteur;
	private Spinner spnHeight;
	
	private PropertyChangeSupport pcs;

	
	
	public ScenePlinthSettingComposite(Composite parent, ScenePreferences preferences) {
		super(parent, SWT.NONE);
		this.preferences = preferences;
		this.pcs = new PropertyChangeSupport(this);
		createControl();
		bind();
	}

	private void bind() {
		spnThickness.setMinimum(1);
		spnThickness.setSelection(Math.round(preferences.getPlinthThickness() * 1000));
		spnHeight.setMinimum(1);
		spnHeight.setSelection(Math.round(preferences.getPlinthHeight() * 1000));
		color = preferences.getPlinthColor();
		colorComposite.setColor(preferences.getPlinthColor());
	}

	private void setColor(Vector3 albedo) {
		this.color = albedo;
		pcs.firePropertyChange("plinth setting changed", null, null);

	}

	private void createControl() {
		setLayout(new GridLayout(2, false));
		
		lblHauteur = new Label(this, SWT.NONE);
		lblHauteur.setText("Hauteur: ");
		
		spnHeight = new Spinner(this, SWT.BORDER);
		spnHeight.setMaximum(1000);
		spnHeight.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spnHeight.addModifyListener(new ModifyListener() {
			
			@Override
			public void modifyText(ModifyEvent e) {
				 height = spnHeight.getSelection() * 1e-3f;		
				 pcs.firePropertyChange("plinth setting changed", null, null);
			}
		});
		
		Label lblEpaisseur = new Label(this, SWT.NONE);
		lblEpaisseur.setText("Epaisseur: ");
		
		spnThickness = new Spinner(this, SWT.BORDER);
		spnThickness.setMaximum(1000);
		spnThickness.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spnThickness.addModifyListener(new ModifyListener() {
			
			@Override
			public void modifyText(ModifyEvent e) {
				thickness = spnThickness.getSelection() * 1e-3f;
				 pcs.firePropertyChange("plinth setting changed", null, null);
			}
		});
		
		lblCouleur = new Label(this, SWT.NONE);
		lblCouleur.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		lblCouleur.setText("Couleur: ");
		
		Composite colorCmp = new Composite(this, SWT.NONE);
		colorCmp.setLayout(new GridLayout(1, false));
		colorCmp.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		colorComposite = new ColorComposite(colorCmp, SWT.NONE);
		colorComposite.getBtncolorChooser().setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, false, true, 1, 1));
		colorComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		GridData gridData = (GridData) colorComposite.getColorLabel().getLayoutData();
		gridData.verticalAlignment = SWT.FILL;
		gridData.horizontalAlignment = SWT.FILL;
		gridData.grabExcessVerticalSpace = true;
		gridData.grabExcessHorizontalSpace = true;
		colorComposite.setLayout(new GridLayout(2, false));
		PropertyChangeListener colorListener = new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
					RGB rgb = (RGB) evt.getNewValue();
					Vector3 albedo = new Vector3(rgb.red / 255.0f, rgb.green/255.0f,rgb.blue / 255.0f);
					setColor(albedo);
					
			}
		};
		colorComposite.addColorListener(colorListener);
	}

	public boolean hasValidInput() {
		return thickness > 0.01f && height > 0.05f && color != null;
	}

	public void apply() {
		preferences.setPlinthHeight(height);
		preferences.setPlinthThickness(thickness);
		preferences.setPlinthColor(color);
	}
	
	public void addPropertyChangeListener(PropertyChangeListener lsitener) {
		pcs.addPropertyChangeListener(lsitener);
	}
	
	public void clearListeners() {
		for(var listner: pcs.getPropertyChangeListeners())
			pcs.removePropertyChangeListener(listner);
	}
}
