package dressing.ui.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;

import gdxapp.scenes.ScenePreferences;

public class ElementConfigPage extends WizardPage implements PropertyChangeListener{
	
	
	private ScenePreferences preferences;
	private ElementConfigComposite composite;

	public ElementConfigPage(ScenePreferences preferences) {
		super("Apparence des éléments");
		this.preferences = preferences;
		this.preferences.addPropertyChangeListener(this);
		setTitle("Configuration des Matériaux de Cuisine");
		setDescription("");
	}
	
	

	@Override
	public boolean isPageComplete() {
		if(composite==null || composite.isDisposed() || !composite.isReady())
			return false;
		if(preferences.getBoxMtl() == null)
			return false;
		if(preferences.getFacadeMtl() == null)
			return false;
		if(preferences.getBackMtl() == null)
			return false;
		
		return true;
		
	}



	@Override
	public void createControl(Composite parent) {
		long t = System.currentTimeMillis();
		composite = new ElementConfigComposite(parent, SWT.EMBEDDED, preferences);
		setControl(composite);
		getWizard().getContainer().updateButtons();
		long duration = System.currentTimeMillis() - t;
		System.err.println("elemnt page control creation took " + duration + "ms");
	}



	@Override
	public void propertyChange(PropertyChangeEvent arg0) {
		if(isCurrentPage())
		{
			if (ElementConfigPage.this != null) {
				setPageComplete(isPageComplete());
				if (getWizard().getContainer() != null)
					getContainer().updateButtons();
			}
		}
	}
	public void clearlistners() {
		preferences.removePropertyChangeListener(this);

	}
	
	@Override
	public void setVisible(boolean visible) {
		// TODO Auto-generated method stub
		super.setVisible(visible);
		if(composite!=null && !composite.isDisposed() && visible) {
			composite.updatePreferences();
		}
	}
	

}
