package dressing.ui.palette;

/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

/*
 * Drag and Drop example snippet: define my own data transfer type
 *
 * For a list of all SWT example snippets see
 * http://www.eclipse.org/swt/snippets/
 * 
 * @since 3.1
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;



 public class PaletteItemTransferType extends ByteArrayTransfer {

    public static final String MYTYPENAME = "custom/myPalette";//doit etre avec ce format pour qui soit parsed avac le awt

    private static final int MYTYPEID = registerType(MYTYPENAME);

    private static PaletteItemTransferType _instance = new PaletteItemTransferType();

    public static PaletteItemTransferType getInstance() {
      return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
      if (!checkMyType(object) || !isSupportedType(transferData)) {
        DND.error(DND.ERROR_INVALID_DATA);
      }
      PaletteItem[] myTypes = (PaletteItem[]) object;
      try {
        // write data to a byte array and then ask super to convert to pMedium
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream writeOut = new DataOutputStream(out);
        for (int i = 0, length = myTypes.length; i < length; i++) {
          byte[] buffer = myTypes[i].cmd.getBytes();
          writeOut.writeInt(buffer.length);
          writeOut.write(buffer);
//          writeOut.writeLong(myTypes[i].fileLength);
//          writeOut.writeLong(myTypes[i].lastModified);
        }
        byte[] buffer = out.toByteArray();
        writeOut.close();
        super.javaToNative(buffer, transferData);
      } catch (IOException e) {
    	  e.printStackTrace();
      }
    }

    public Object nativeToJava(TransferData transferData) {
      if (isSupportedType(transferData)) {
        byte[] buffer = (byte[]) super.nativeToJava(transferData);
        if (buffer == null)
          return null;
        ByteArrayInputStream in = new ByteArrayInputStream(buffer);
        return byteToPojo(in);

      }

      return null;
    }

    public Object byteToPojo(InputStream inputstream)
    {
    	 DataInputStream readIn = new DataInputStream(inputstream);
        PaletteItem[] myData = new PaletteItem[0];
        try {

          while (readIn.available() > 0) {
        	  PaletteItem datum = new PaletteItem();
            int size = readIn.readInt();
            byte[] name = new byte[size];
            inputstream.read(name);
            datum.cmd = new String(name);
//            datum.fileLength = readIn.readLong();
//            datum.lastModified = readIn.readLong();
            PaletteItem[] newMyData = new PaletteItem[myData.length + 1];
            System.arraycopy(myData, 0, newMyData, 0, myData.length);
            newMyData[myData.length] = datum;
            myData = newMyData;
          }
          readIn.close();
        } catch (IOException ex) {
          return null;
        }
        return myData;
    }
    protected String[] getTypeNames() {
      return new String[] { MYTYPENAME };
    }

    protected int[] getTypeIds() {
      return new int[] { MYTYPEID };
    }

    boolean checkMyType(Object object) {
      if (object == null || !(object instanceof PaletteItem[]) || ((PaletteItem[]) object).length == 0) {
        return false;
      }
      PaletteItem[] myTypes = (PaletteItem[]) object;
      for (int i = 0; i < myTypes.length; i++) {
        if (myTypes[i] == null || myTypes[i].cmd==null) {
          return false;
        }
      }
      return true;
    }

    protected boolean validate(Object object) {
      return checkMyType(object);
    }
  }