package dressing.ui.caisson;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;

import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.model.ModelProvider;
import dressing.model.Piece2D;
import dressing.model.Space3DFree;
import gdxapp.object3d.GolaProfile;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.Profile;
import gdxapp.scenes.SceneEvent;
import param.MechanicPublicParam;
import param.TypeDefElement;

public class ListFacadesSettingCmp extends Composite {
	
	private KitchenElement element;
	private List<FacadeConfigComposite> facadeSettings;
	private FacadeHandleConfigurer profileConfigurer;


	public ListFacadesSettingCmp(Composite parent, KitchenElement element) {
		super(parent, SWT.NONE);
		this.element = element;
		createControl();
	}

	private void createControl() {
		setLayout(new FillLayout());
		ExpandBar expandBar = new ExpandBar(this, SWT.V_SCROLL);
        expandBar.addExpandListener(new ExpandListener() {
            @Override
            public void itemExpanded(ExpandEvent e) {
                for (ExpandItem item : expandBar.getItems()) {
                    if (item != e.item) {
                        item.setExpanded(false);
                        item.setHeight(0);
                    }
                }
                ExpandItem expandedItem = (ExpandItem) e.item;
                expandedItem.setHeight(expandedItem.getControl().computeSize(SWT.DEFAULT, SWT.DEFAULT).y);
            }
            @Override
            public void itemCollapsed(ExpandEvent e) {
                ExpandItem collapsedItem = (ExpandItem) e.item;
                collapsedItem.setHeight(0);
            }
        });
        
		createFacadeTab(expandBar);
	}
	
	private void createFacadeTab(ExpandBar expandBar) {
		List<Piece2D> facades = element.getDesignObject().getListPieces().stream().filter((piece) -> {
			return piece.getPiecetype().isFacade();
		}).toList();
		
		facadeSettings = new ArrayList<FacadeConfigComposite>();
		for(var facade: facades) {
			ExpandItem item = new ExpandItem(expandBar, SWT.NONE);
			item.setText(facade.getName());
	        Composite composite = new Composite(expandBar, SWT.NONE);
	        composite.setLayout(new GridLayout(1, false));
	       
			FacadeConfigComposite facadeConfigComposite = new FacadeConfigComposite(composite,facade, element.getDoorHandle(facade.getName()));
			facadeConfigComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
			item.setControl(composite);
	        item.setHeight(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT).y);
	        facadeSettings.add(facadeConfigComposite);
		}
		if(element.getProfile() != null) {
			ExpandItem item = new ExpandItem(expandBar, SWT.NONE);
			item.setText("Profilée");
	        Composite composite = new Composite(expandBar, SWT.NONE);
	        composite.setLayout(new GridLayout(1, false));
	       
			profileConfigurer = new FacadeHandleConfigurer(composite, element.getProfile());
			profileConfigurer.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
			item.setControl(composite);
	        item.setHeight(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT).y);
		}
		layout(true, true);
	}
	
	public void applySetting() {
		for(var setting: facadeSettings)
			setting.update();
		if(profileConfigurer != null) {
			Profile profile =(Profile) profileConfigurer.getTmpDoorHandle().cpy();
			profile.setMaterial(profileConfigurer.getMtl());
			element.setProfile(profile);
		}
		try {
			updateEmf();
			((Space3DFree)element.getDesignObject()).update();
			element.setRequireRefrech(true);
			EventDriver.getDriver().deliverEvent(new Event(SceneEvent.OBJECT_CHANGED.name(), element));
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void updateEmf() {
		var design = element.getDesignObject();
		if(element.getProfile() != null) {
			String[] keys = {"sansPoignee_CavityLeft", "sansPoignee_CavityRight"};
			boolean value = element.getProfile() instanceof GolaProfile? true:false; 
			for(var key: keys) {
				try {
					MechanicPublicParam param = design.getMechanicDesignDefinition().getPublicParam(key);
					if (param != null) {
						TypeDefElement element = param.getTypedef().getElement(String.valueOf(value));
						param.setTypedefelement(element);
					}
				}catch(Exception e) {
					e.printStackTrace();
				}
			}
		}else {
			var directions = ModelProvider.getModelroot().getCategorie().getTypedef().
					stream().filter(type -> type.getKey().equals("PORTE_DIRECTION")).toList();
			var right = directions.get(0).getElement("RIGHT");
			var left = directions.get(0).getElement("LEFT");
			MechanicPublicParam paramPorteDirection = null;
			try {
				paramPorteDirection = design.getElementPorteDirection();
				TypeDefElement porteDirection = paramPorteDirection.getTypedefelement();
				for(var facade: element.getDoorHandles().values()) {
					int[] position =  facade.getRelativePosition();
					if(position[0] == -1) {
						paramPorteDirection.setTypedefelement(left);
					}else {
						paramPorteDirection.setTypedefelement(right);
					}
					break;
				}

			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		
		
		
		


	}

}
