package dressing.ui;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.layout.GridData;

public class ProgressBarComposite extends Composite {
	
	private ProgressBar progressBar;
	private Label lblTask;
	private int tasksCount;
	private int tasksDone;

	public ProgressBarComposite(Composite parent, int style) {
		super(parent, style);
		setLayout(new GridLayout(2, false));
		
		lblTask = new Label(this, SWT.NONE);
		GridData gd_lblTask = new GridData(SWT.LEFT, SWT.FILL, true, false, 1, 1);
		gd_lblTask.minimumWidth = 500;
		lblTask.setLayoutData(gd_lblTask);
		lblTask.setText("on going task");
		
		progressBar = new ProgressBar(this, SWT.NONE);
		progressBar.setLayoutData(new GridData(SWT.RIGHT, SWT.FILL, false, false, 1, 1));
		setVisible(false);
	}
	
	public void advance(int steps) {
		tasksDone += steps;
		int progress = Math.round((tasksDone/(float) tasksCount) * 100.0f);
		setProgress(progress);
		
		if(progress == 100)
			setVisible(false);
	}
	
	public void setProgress(int progress) {
		progressBar.setSelection(progress);
	}
	
	public void setTask(String task) {
		String job = task + ("(" + progressBar.getSelection() + "%)");
		lblTask.setText(job);
	}
	
	public void setVisible(boolean visible) {
		progressBar.setVisible(visible);
		lblTask.setVisible(visible);

	}

	public int getTasksCount() {
		return tasksCount;
	}

	public void setTasksCount(int tasksCount) {
		this.tasksCount = tasksCount;
		this.tasksDone = 0;
		setProgress(0);
		setVisible(true);
	}
	
	
	
	
	

}
