package dressing.ui.Control;

import java.util.Map;

import javax.annotation.PostConstruct;

import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Stage;

import dressing.events.Event;
import dressing.events.EventHandler;
import dressing.ui.caisson.ElementFacadeConfigWindow;
import dressing.ui.parts.GdxPart;
import dressing.ui.util.EditorWindow;
import dressing.ui.util.GeometricObjectConfigWindow;
import dressing.ui.util.MesureWidow;
import dressing.ui.util.ModelInstanceEditorWindow;
import dressing.ui.util.PlinthCreationWindow;
import dressing.ui.util.WallSettingWindow;
import gdxapp.Commun.ScreenController;
import gdxapp.object3d.GeometryObject;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.Object3D;
import gdxapp.object3d.PlinthObject;
import gdxapp.object3d.Wall;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import gdxapp.scenes.SceneEvent;
import gdxapp.ui.MoveToWindow;

@Creatable
public class ConfigWindowsInvoker implements EventHandler {
	
	
	public ConfigWindowsInvoker() {}
	
	@PostConstruct
	void init() {
		subscribe(SceneEvent.MODIFY_OBJECT.name(), SceneEvent.EDIT_OBJECT.name(), SceneEvent.INVOKE_MOVE_WINDOW.name());
	}

	@Override
	public void handle(Event event) {
		
		String topic = event.getTopic();
		if(topic == SceneEvent.INVOKE_MOVE_WINDOW.name()) {
			Map details = (Map) event.getData();
			ScreenController controller = (ScreenController) details.get("context");
			Object3D target = (Object3D) details.get("target");
			Gdx.app.postRunnable(() -> {
				MoveToWindow window = new MoveToWindow(target, controller.getUIStage());
				window.open();
			});
			return;
		}
		try {
			WorldObject object = (WorldObject) event.getData();
			openConfigWindow(object, topic);
		}catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	
	public void openConfigWindow(WorldObject object, String topic) {
		Display.getDefault().asyncExec(() -> {
				if(object instanceof Wall) {
						invokeWallSettingWindow((Wall) object);
				}else if(object instanceof PlinthObject){
					invokePlinthCreationWindow((PlinthObject) object);
				}else if(object instanceof GeometryObject) {
					invokeGeometryObjectConfigWindow((GeometryObject) object);
				}else if(object instanceof KitchenElement) {
					if(topic.equals(SceneEvent.MODIFY_OBJECT.name())) {
						invokeMeasureWindow((KitchenElement) object);
					}else {
						invokeElementFacadeConfigWindow((KitchenElement) object);
					}
				}else if(object.getType() == ObjectType.MODELED) {
					invokeModelInstanceEditorWindow(object);
				}
		});
	}
	
	public void invokeMeasureWindow(KitchenElement element) {
		MesureWidow mesureWidow = MesureWidow.getInstance();
		mesureWidow.setKitchenElemtn(element);
		mesureWidow.show();
	}
	
	public void invokeWallSettingWindow(Wall wall) {
		Shell shell = new Shell(Display.getDefault());
		WallSettingWindow window = new WallSettingWindow(shell, wall);
		window.open();
	}
	
	public void invokePlinthCreationWindow(PlinthObject plinthObject) {
		PlinthCreationWindow window = new PlinthCreationWindow(GdxPart.parentShell, plinthObject);
		window.open();
	}
	
	
	public void invokeGeometryObjectConfigWindow(GeometryObject geometry) {
		Shell shell = new Shell(Display.getDefault());
		GeometricObjectConfigWindow window = new GeometricObjectConfigWindow(shell, geometry);
		window.open();
	}
	
	public void invokeEdgeMesureWindow() {
		
	}
	
	public void invokeElementFacadeConfigWindow(KitchenElement element) {
		ElementFacadeConfigWindow facadeConfigWindow = new ElementFacadeConfigWindow(element);
		facadeConfigWindow.open();
	}
	
	public void invokeModelInstanceEditorWindow(WorldObject object) {
		ModelInstanceEditorWindow mechanicDesignWindow = new ModelInstanceEditorWindow(Display.getDefault().getActiveShell(), object, EditorWindow.update);
		mechanicDesignWindow.create();
		mechanicDesignWindow.open();
	}

}
