package dressing.reporting.htmlReporting;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import dressing.model.Piece2D;
import param.Material;
import param.PieceType;
import reporting.data.handle.PieceCoupe;

public class ReportUtils {
	private static ReportUtils instance;

	/**
	 * Returns an instance of ArrayContentProvider. Since instances of this
	 * class do not maintain any state, they can be shared between multiple
	 * clients.
	 *
	 * @return an instance of ArrayContentProvider
	 *
	 * @since 3.5
	 */
	public static ReportUtils getInstance() {
		synchronized(ReportUtils.class) {
			if (instance == null) {
				instance = new ReportUtils();
			}
			return instance;
		}
	}

	
	
	public List<PieceCoupe> compactPieces2D(List<Piece2D> pieces,boolean isgroup){
		List<PieceCoupe> coupePieces=new ArrayList<PieceCoupe>();
		for(Piece2D piece:pieces) {
			if((piece.getMechanicDesignElementDefinition().getMaterialType()==null 
					||piece.getMechanicDesignElementDefinition().getMaterialType().getMaterial()==null
					||!piece.getMechanicDesignElementDefinition().getMaterialType().getMaterial().isProduction())
						||(!piece.getMechanicDesignElementDefinition().getType().equals(PieceType.PIECE2D))) {
				continue;
			}
			boolean found=false;
			if(!coupePieces.isEmpty() && isgroup) {
				for(PieceCoupe coupe:coupePieces ) {
					if(coupe.contains(piece)) {
						coupe.addPiece(piece);
						found=true;
						break;
					}
				}
			}
			
			if(!found) {
				PieceCoupe coupe=new PieceCoupe(piece.getName(),piece);
				coupePieces.add(coupe);
			}
		}
		
		coupePieces.sort(new Comparator<PieceCoupe>() {

			@Override
			public int compare(PieceCoupe arg0, PieceCoupe arg1) {
				
					
				
				return arg0.getName().compareTo(arg1.getName());
			}
			
		});
		return coupePieces;
	}
	
	public Map<Material,List<PieceCoupe>> groupByMaterial(List<PieceCoupe> pieces){
		Map<Material,List<PieceCoupe>> mpMatPiece=new HashMap<Material, List<PieceCoupe>>();
		for(PieceCoupe piece:pieces) {
			Material pieceMAT=piece.getMaterialpiece();
			if(!mpMatPiece.containsKey(pieceMAT)) {
				mpMatPiece.put(pieceMAT,new ArrayList<PieceCoupe>());
			}
			mpMatPiece.get(pieceMAT).add(piece);

		}
		
		
		
		return mpMatPiece;
	}
}
