package dressing.model.persistence.dpos;

import com.badlogic.gdx.graphics.Color;
import dressing.mathutils.Surface;
import gdxapp.ui.Note;
import jakarta.xml.bind.annotation.XmlRootElement;


@XmlRootElement(name="note")
public class NoteDPO implements DPO<Note> {

	private static final long serialVersionUID = 1L;
	
	private String content;
	private float size;
	private Color color;
	private Surface context;
	private float x,y;
	
	public NoteDPO() {}
	
	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public float getSize() {
		return size;
	}

	public void setSize(float size) {
		this.size = size;
	}

	public Color getColor() {
		return color;
	}

	public void setColor(Color color) {
		this.color = color;
	}

	public Surface getContext() {
		return context;
	}

	public void setContext(Surface context) {
		this.context = context;
	}

	public float getX() {
		return x;
	}

	public void setX(float x) {
		this.x = x;
	}

	public float getY() {
		return y;
	}

	public void setY(float y) {
		this.y = y;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	@Override
	public DPO<Note> from(Note entity) {
		NoteDPO dpo = new NoteDPO();
		dpo.content = entity.getContent();
		dpo.size = entity.getSize();
		dpo.color = entity.getColor();
		dpo.context = entity.getContext();
		dpo.x = entity.getX();
		dpo.y = entity.getY();
		return dpo;
	}

	
	@Override
	public Note get() {
		Note note = new Note();
		note.setContent(content);
		note.setSize(size);
		note.setContext(context);
		note.setColor(color);
		note.setPosition(x, y);
		note.calculateSize();
		return note;
	}
		
}
