package dressing.cam.model;


import dressing.model.DesignException;
import dressing.model.Piece2D;

public class Cuboid extends CamShape {

	public double longeur;
	public double hauteur;
	public double depth;
	public double zbottem;

	public Cuboid(Usinage usin, PlanUsinage plan) {
		super(plan,usin);
		init();
	}

	public Cuboid(Usinage usin) {
		this(usin,PlanUsinage.FRONT);
	}
	public void check() throws DesignException {
		if (usin == null) {
			throw new DesignException("impossible de créer un coboid avec d'usinage null");
		}
		if (!(usin instanceof Usinage)) {
			throw new DesignException("impossible de créer un coboid avec que des objet d'usinage");
		}
		if (usin.getParentdesign() == null || !(usin.getParentdesign() instanceof Piece2D)) {
			throw new DesignException(
					"impossible de créer un coboid avec usinage de parent null ou diffirent a un piece");

		}
	}

	@Override
	protected void init() {
		this.xPos = getXpos(usin, plan);
		this.yPos = getYpos(usin, plan);
		this.longeur = getWidth(usin, plan);
		this.hauteur = getHeight(usin, plan);
		this.zbottem = -getDepth(usin, plan);
		this.depth = getDepth(usin, plan);
	}

	@Override
	public String getGcode() {
		String gcode = "";
		double x = getxPos();
		double y = getyPos();
		double h = getHauteur();
		double l = getLongeur();
		double z = getZbottem();
		gcode += Tool.RADUIS_COMPENSATION_RIGHT_COMMAND + Tool.END_OF_LINE;
		gcode += Tool.X_CODE + x + " " + Tool.Y_CODE + y + Tool.END_OF_LINE;
		gcode += Tool.Z_CODE + z + Tool.END_OF_LINE;
		gcode += Tool.X_CODE + (x + l) + Tool.END_OF_LINE;
		gcode += Tool.Y_CODE + (y + h) + Tool.END_OF_LINE;
		gcode += Tool.X_CODE + x + Tool.END_OF_LINE;
		gcode += Tool.Y_CODE + y + Tool.END_OF_LINE;
		gcode += Tool.Z_CODE + Tool.Z_OFFSET + Tool.END_OF_LINE;
		gcode += Tool.RADIUS_COMPENSATION_OFF_COMMAND + Tool.END_OF_LINE;
		return gcode;
	}

	private double getXpos(Usinage design, PlanUsinage perspectiveview) {
		Piece2D piece = (Piece2D) design.getParentdesign();
		if(perspectiveview == null)
			perspectiveview = PlanUsinage.FRONT;
		switch (perspectiveview) {
		case FRONT:
			return design.getXpos();
		case BACK:
			return piece.getLongeurext() - design.getXpos()- design.getLongeurext();
		case RIGHT:
			return piece.getProfondeurext() - design.getZpos() - design.getProfondeurext();
		case LEFT:
			return design.getZpos();
		case DOWN:
			return design.getXpos();
		case TOP:
			return design.getXpos();
		default:
			return 0;
		}

	}

	private double getYpos(Usinage design, PlanUsinage perspectiveview) {
		Piece2D piece = (Piece2D) design.getParentdesign();
		if(perspectiveview == null)
			perspectiveview = PlanUsinage.FRONT;
		switch (perspectiveview) {
		case FRONT:
			return design.getYpos();
		case BACK:
			return design.getYpos();
		case RIGHT:
			return design.getYpos();
		case LEFT:
			return design.getYpos();
		case DOWN:
			return design.getZpos();
		case TOP:
			return piece.getProfondeurext() - design.getZpos() - design.getProfondeurext();
		default:
			return 0;
		}

	}

	private double getHeight(Usinage rn, PlanUsinage perspectiveview) {
		if(perspectiveview == null)
			perspectiveview = PlanUsinage.FRONT;
		switch (perspectiveview) {
		case FRONT:
			return rn.getHauteurext();
		case BACK:
			return rn.getHauteurext();
		case RIGHT:
			return rn.getHauteurext();
		case LEFT:
			return rn.getHauteurext();
		case DOWN:
			return rn.getProfondeurext();
		case TOP:
			return rn.getProfondeurext();
		default:
			return 0;
		}

	}

	private double getWidth(Usinage rn, PlanUsinage perspectiveview) {
		if(perspectiveview == null)
			perspectiveview = PlanUsinage.FRONT;
		switch (perspectiveview) {
		case FRONT:
			return rn.getLongeurext();
		case BACK:
			return rn.getLongeurext();
		case RIGHT:
			return rn.getProfondeurext();
		case LEFT:
			return rn.getProfondeurext();
		case DOWN:
			return rn.getLongeurext();
		case TOP:
			return rn.getLongeurext();
		default:
			return 0;
		}

	}

	public static double getDepth(Usinage rn, PlanUsinage perspectiveview) {
		if(perspectiveview == null)
			perspectiveview = PlanUsinage.FRONT;
		switch (perspectiveview) {
		case FRONT:
			return rn.getProfondeurext();
		case BACK:
			return rn.getProfondeurext();
		case RIGHT:
			return rn.getLongeurext();
		case LEFT:
			return rn.getLongeurext();
		case DOWN:
			return rn.getHauteurext();
		case TOP:
			return rn.getHauteurext();
		default:
			return 0;
		}

	}

	
	public double getLongeur() {
		return longeur;
	}

	public void setLongeur(double longeur) {
		this.longeur = longeur;
	}

	public double getHauteur() {
		return hauteur;
	}

	public void setHauteur(double hauteur) {
		this.hauteur = hauteur;
	}

	public double getDepth() {
		return depth;
	}

	public void setDepth(double depth) {
		this.depth = depth;
	}

	public double getZbottem() {
		return zbottem;
	}

	public void setZbottem(double zbottem) {
		this.zbottem = zbottem;
	}

}
