/*
 * Decompiled with CFR 0.152.
 */
package api.graphics;

import api.graphics.Texture;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL40;

public class Framebuffer {
    protected int id = GL40.glGenFramebuffers();

    public void bind() {
        GL40.glBindFramebuffer((int)36160, (int)this.id);
    }

    public void unbind() {
        GL40.glBindFramebuffer((int)36160, (int)this.id);
    }

    public void cleanUp() {
        GL40.glDeleteFramebuffers((int)this.id);
    }

    public void check() {
        if (GL30.glCheckFramebufferStatus((int)36160) != 36053) {
            throw new RuntimeException("Framebuffer is not complete!");
        }
    }

    public Texture getAttachment(int attachment) {
        IntBuffer id = IntBuffer.allocate(1);
        this.bind();
        GL40.glGetFramebufferAttachmentParameteriv((int)36160, (int)attachment, (int)36049, (IntBuffer)id);
        this.unbind();
        if (id.get(0) == 0) {
            return null;
        }
        Texture texture = new Texture();
        texture.setHandle(id.get(0));
        return texture;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

