/*
 * Decompiled with CFR 0.152.
 */
package com.frs.supercad.parametric_model.api.core;

import com.frs.supercad.parametric_model.api.core.ModelParameter;
import com.frs.supercad.parametric_model.api.core.ParametricModel;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ParametricModelLoader {
    public ParametricModel loadModel(String path) {
        String src = this.loadSrc(path);
        JSONParser parser = new JSONParser();
        try {
            JSONObject json = (JSONObject)parser.parse(src);
            String name = (String)json.get((Object)"name");
            String modelID = (String)json.get((Object)"id");
            String modelType = (String)json.get((Object)"type");
            JSONArray parameters = (JSONArray)json.get((Object)"parameters");
            List<ModelParameter> params = this.parseParameters(parameters);
            ParametricModel model = new ParametricModel();
            model.setName(name);
            model.setType(ParametricModel.ModelType.valueOf(modelType));
            model.setId(UUID.fromString(modelID));
            model.setParameters(params);
            model.setPath(path);
            model.setSource(json);
            return model;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String loadSrc(String path) {
        String src = null;
        try {
            src = Files.readString(Path.of(path, new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return src;
    }

    private List<ModelParameter> parseParameters(JSONArray json) {
        ArrayList<ModelParameter> params = new ArrayList<ModelParameter>();
        for (Object parameterSrc : json) {
            ModelParameter param = this.parseParameter((JSONObject)parameterSrc);
            if (param == null) continue;
            params.add(param);
        }
        return params;
    }

    public ModelParameter parseParameter(JSONObject json) {
        String clazz = (String)json.get((Object)"type");
        String ref = (String)json.get((Object)"reference");
        String dsiplayName = (String)json.get((Object)"display_name");
        Object defaultValue = json.get((Object)"default_value");
        ModelParameter parameter = null;
        try {
            Class<?> type = ParametricModelLoader.getClass(clazz);
            if (defaultValue.getClass() == Double.class) {
                defaultValue = Float.valueOf(((Double)defaultValue).floatValue());
            }
            parameter = new ModelParameter(type, ref, dsiplayName, defaultValue);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return parameter;
    }

    private static Class<?> getClass(String name) throws ClassNotFoundException {
        switch (name) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        return Class.forName(name);
    }
}

